/*
 * Decompiled with CFR 0.152.
 */
package com.centralnexus.input;

import com.centralnexus.input.ExtendedJoystick;
import com.centralnexus.input.JoystickListener;
import com.centralnexus.input.JoystickNotifier;
import com.centralnexus.input.jjstick;
import java.io.IOException;

public class Joystick {
    public static final int HAS_Z = 1;
    public static final int HAS_R = 2;
    public static final int HAS_U = 4;
    public static final int HAS_V = 8;
    public static final int HAS_POV = 16;
    public static final int HAS_POV4DIR = 32;
    public static final int HAS_POVCONT = 64;
    public static final float POV_CENTERED = -0.01f;
    public static final float POV_FORWARD = 0.0f;
    public static final float POV_RIGHT = 90.0f;
    public static final float POV_BACKWARD = 180.0f;
    public static final float POV_LEFT = 270.0f;
    public static final int BUTTON1 = 1;
    public static final int BUTTON2 = 2;
    public static final int BUTTON3 = 4;
    public static final int BUTTON4 = 8;
    public static final int BUTTON5 = 16;
    public static final int BUTTON6 = 32;
    public static final int BUTTON7 = 64;
    public static final int BUTTON8 = 128;
    public static final int BUTTON9 = 256;
    public static final int BUTTON10 = 512;
    public static final int BUTTON11 = 1024;
    public static final int BUTTON12 = 2048;
    public static final int BUTTON13 = 4096;
    public static final int BUTTON14 = 8192;
    public static final int BUTTON15 = 16384;
    public static final int BUTTON16 = 32768;
    public static final int BUTTON17 = 65536;
    public static final int BUTTON18 = 131072;
    public static final int BUTTON19 = 262144;
    public static final int BUTTON20 = 524288;
    public static final int BUTTON21 = 0x100000;
    public static final int BUTTON22 = 0x200000;
    public static final int BUTTON23 = 0x400000;
    public static final int BUTTON24 = 0x800000;
    public static final int BUTTON25 = 0x1000000;
    public static final int BUTTON26 = 0x2000000;
    public static final int BUTTON27 = 0x4000000;
    public static final int BUTTON28 = 0x8000000;
    public static final int BUTTON29 = 0x10000000;
    public static final int BUTTON30 = 0x20000000;
    public static final int BUTTON31 = 0x40000000;
    public static final int BUTTON32 = Integer.MIN_VALUE;
    static final int AXIS_TOTAL = 7;
    private static final int AXIS_X = 0;
    private static final int AXIS_Y = 1;
    private static final int AXIS_Z = 2;
    private static final int AXIS_R = 3;
    private static final int AXIS_U = 4;
    private static final int AXIS_V = 5;
    private static final int AXIS_POV = 6;
    private static JoystickNotifier[] joyNotifier;
    private int id = 0;
    private float deadZone = 0.0f;
    private int capabilities = 0;
    float[] axisValues;
    JoystickNotifier myJoyNotifier;

    public static final native int getNumDevices();

    public static synchronized native boolean isPluggedIn(int var0);

    static synchronized native int poll(int var0, float[] var1);

    private static native int getCapabilities(int var0);

    private static native int getNumButtons(int var0);

    private static native int getNumAxes(int var0);

    private static native String toString(int var0);

    Joystick(int n) throws IOException {
        if (Joystick.isPluggedIn(n)) {
            this.id = n;
            if (joyNotifier[n] == null) {
                Joystick.joyNotifier[n] = new JoystickNotifier(this);
            }
        } else {
            throw new IOException("Invalid joystick ID: " + n);
        }
        this.myJoyNotifier = joyNotifier[n];
        this.axisValues = Joystick.joyNotifier[n].axisValues;
        this.capabilities = Joystick.getCapabilities(n);
        this.myJoyNotifier.buttonValues = Joystick.poll(n, this.axisValues);
    }

    public static Joystick createInstance() throws IOException {
        int n = Joystick.getNumDevices();
        int n2 = 0;
        while (n2 < n && !Joystick.isPluggedIn(n2)) {
            ++n2;
        }
        if (n2 >= n) {
            throw new IOException("Joystick not found.");
        }
        return Joystick.createInstance(n2);
    }

    public static Joystick createInstance(int n) throws IOException {
        if (n < 0 || Joystick.getNumDevices() <= n) {
            throw new IOException("Invalid joystick ID: " + n);
        }
        int n2 = Joystick.getCapabilities(n);
        Joystick joystick = n2 == 0 || n2 == 1 ? new Joystick(n) : new ExtendedJoystick(n);
        return joystick;
    }

    public final int getID() {
        return this.id;
    }

    public void poll() {
        this.myJoyNotifier.buttonValues = Joystick.poll(this.id, this.axisValues);
    }

    public int getCapabilities() {
        return this.capabilities;
    }

    public final boolean getCapability(int n) {
        return (this.capabilities & n) == n;
    }

    final float removeDeadZone(float f) {
        return f <= -this.deadZone || this.deadZone <= f ? f : 0.0f;
    }

    public synchronized float getX() {
        return this.removeDeadZone(this.axisValues[0]);
    }

    public synchronized float getY() {
        return this.removeDeadZone(this.axisValues[1]);
    }

    public synchronized float getZ() {
        if ((this.capabilities & 1) == 1) {
            return this.removeDeadZone(this.axisValues[2]);
        }
        return 0.0f;
    }

    public synchronized float getR() {
        if ((this.capabilities & 2) == 2) {
            return this.removeDeadZone(this.axisValues[3]);
        }
        return 0.0f;
    }

    public synchronized float getU() {
        if ((this.capabilities & 4) == 4) {
            return this.removeDeadZone(this.axisValues[4]);
        }
        return 0.0f;
    }

    public synchronized float getV() {
        if ((this.capabilities & 8) == 8) {
            return this.removeDeadZone(this.axisValues[5]);
        }
        return 0.0f;
    }

    public synchronized float getPOV() {
        if ((this.capabilities & 0x10) == 16) {
            return this.axisValues[6];
        }
        return 0.0f;
    }

    public int getButtons() {
        return this.myJoyNotifier.buttonValues;
    }

    public boolean isButtonDown(int n) {
        return (this.myJoyNotifier.buttonValues & n) == n;
    }

    public int getNumButtons() {
        return Joystick.getNumButtons(this.id);
    }

    public int getNumAxes() {
        return Joystick.getNumAxes(this.id);
    }

    public final float getDeadZone() {
        return this.deadZone;
    }

    public final void setDeadZone(float f) {
        if (!(0.0f <= f) || !(f <= 1.0f)) {
            throw new IllegalArgumentException("Dead Zone needs to be in the range 0 and 1: " + f);
        }
        this.deadZone = f;
    }

    public final void setDeadZone(double d) {
        this.setDeadZone((float)d);
    }

    public void addJoystickListener(JoystickListener joystickListener) {
        this.myJoyNotifier.addJoystickListener(this, joystickListener);
    }

    public void removeJoystickListener(JoystickListener joystickListener) {
        this.myJoyNotifier.removeJoystickListener(this, joystickListener);
    }

    public void setPollInterval(int n) {
        this.myJoyNotifier.setPollInterval(n);
    }

    public int getPollInterval() {
        return this.myJoyNotifier.getPollInterval();
    }

    public String toString() {
        return Joystick.toString(this.id) + " [id=" + this.id + "]";
    }

    static {
        try {
            new jjstick();
            joyNotifier = new JoystickNotifier[Joystick.getNumDevices()];
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            unsatisfiedLinkError.fillInStackTrace();
            throw unsatisfiedLinkError;
        }
    }
}

