/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d.graph;

import java.util.Collections;
import java.util.Comparator;
import org.eclipse.draw2d.graph.Node;
import org.eclipse.draw2d.graph.NodeList;

public class Rank
extends NodeList {
    private Comparator comparator = new MedianComparator();
    final int hash = new Object().hashCode();
    public int total;

    public void add(Node n) {
        super.add(n);
    }

    public int count() {
        return super.size();
    }

    public boolean equals(Object o) {
        return o == this;
    }

    public int hashCode() {
        return this.hash;
    }

    public void sort() {
        Collections.sort(this, this.comparator);
    }

    public void assignIndices() {
        this.total = 0;
        int i = 0;
        while (i < this.size()) {
            Node node = this.getNode(i);
            int mag = node.incoming.size() + node.outgoing.size() + 1;
            this.total += mag;
            node.index = this.total;
            this.total += mag;
            ++i;
        }
    }

    static class MedianComparator
    implements Comparator {
        MedianComparator() {
        }

        public int compare(Object o1, Object o2) {
            double diff = ((Node)o1).sortValue - ((Node)o2).sortValue;
            if (diff < 0.0) {
                return -1;
            }
            if (diff > 0.0) {
                return 1;
            }
            return 0;
        }
    }
}

