/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d.geometry;

import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionDimension;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.Rectangle;

public final class PrecisionRectangle
extends Rectangle {
    public double preciseHeight;
    public double preciseWidth;
    public double preciseX;
    public double preciseY;

    public PrecisionRectangle() {
    }

    public PrecisionRectangle(Rectangle rect) {
        super(rect);
        if (rect instanceof PrecisionRectangle) {
            PrecisionRectangle rectangle = (PrecisionRectangle)rect;
            this.preciseX = rectangle.preciseX;
            this.preciseY = rectangle.preciseY;
            this.preciseWidth = rectangle.preciseWidth;
            this.preciseHeight = rectangle.preciseHeight;
        } else {
            this.preciseX = rect.x;
            this.preciseY = rect.y;
            this.preciseWidth = rect.width;
            this.preciseHeight = rect.height;
        }
        this.updateInts();
    }

    public Rectangle getCopy() {
        return this.getPreciseCopy();
    }

    public PrecisionRectangle getPreciseCopy() {
        PrecisionRectangle result = new PrecisionRectangle();
        result.preciseX = this.preciseX;
        result.preciseY = this.preciseY;
        result.preciseWidth = this.preciseWidth;
        result.preciseHeight = this.preciseHeight;
        result.updateInts();
        return result;
    }

    public void performScale(double factor) {
        this.preciseX *= factor;
        this.preciseY *= factor;
        this.preciseWidth *= factor;
        this.preciseHeight *= factor;
        this.updateInts();
    }

    public void performTranslate(int dx, int dy) {
        this.preciseX += (double)dx;
        this.preciseY += (double)dy;
        this.x += dx;
        this.y += dy;
    }

    public double preciseBottom() {
        return this.preciseHeight + this.preciseY;
    }

    public double preciseRight() {
        return this.preciseWidth + this.preciseX;
    }

    public Rectangle resize(Dimension sizeDelta) {
        if (sizeDelta instanceof PrecisionDimension) {
            PrecisionDimension pd = (PrecisionDimension)sizeDelta;
            this.preciseWidth += pd.preciseWidth;
            this.preciseHeight += pd.preciseHeight;
        } else {
            this.preciseWidth += (double)sizeDelta.width;
            this.preciseHeight += (double)sizeDelta.height;
        }
        this.updateInts();
        return this;
    }

    public void setHeight(double value) {
        this.preciseHeight = value;
        this.height = (int)Math.floor(this.preciseHeight + 1.0E-9);
    }

    public void setWidth(double value) {
        this.preciseWidth = value;
        this.width = (int)Math.floor(this.preciseWidth + 1.0E-9);
    }

    public void setX(double value) {
        this.preciseX = value;
        this.x = (int)Math.floor(this.preciseX + 1.0E-9);
    }

    public void setY(double value) {
        this.preciseY = value;
        this.y = (int)Math.floor(this.preciseY + 1.0E-9);
    }

    public Rectangle translate(Point p) {
        if (p instanceof PrecisionPoint) {
            PrecisionPoint pp = (PrecisionPoint)p;
            this.preciseX += pp.preciseX;
            this.preciseY += pp.preciseY;
        } else {
            this.preciseX += (double)p.x;
            this.preciseY += (double)p.y;
        }
        this.updateInts();
        return this;
    }

    public PrecisionRectangle union(PrecisionRectangle other) {
        double newright = Math.max(this.preciseRight(), other.preciseRight());
        double newbottom = Math.max(this.preciseBottom(), other.preciseBottom());
        this.preciseX = Math.min(this.preciseX, other.preciseX);
        this.preciseY = Math.min(this.preciseY, other.preciseY);
        this.preciseWidth = newright - this.preciseX;
        this.preciseHeight = newbottom - this.preciseY;
        this.updateInts();
        return this;
    }

    public final void updateInts() {
        this.x = (int)Math.floor(this.preciseX + 1.0E-9);
        this.y = (int)Math.floor(this.preciseY + 1.0E-9);
        this.width = (int)Math.floor(this.preciseWidth + this.preciseX + 1.0E-9) - this.x;
        this.height = (int)Math.floor(this.preciseHeight + this.preciseY + 1.0E-9) - this.y;
    }
}

