/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.runtime.adaptor;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.core.runtime.adaptor.EnvironmentInfo;
import org.eclipse.osgi.framework.log.FrameworkLog;
import org.eclipse.osgi.framework.log.FrameworkLogEntry;
import org.eclipse.osgi.framework.util.SecureAction;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkEvent;

public class EclipseLog
implements FrameworkLog {
    private static final String PASSWORD = "-password";
    protected static final String SESSION = "!SESSION";
    protected static final String ENTRY = "!ENTRY";
    protected static final String SUBENTRY = "!SUBENTRY";
    protected static final String MESSAGE = "!MESSAGE";
    protected static final String STACK = "!STACK";
    protected static final String LINE_SEPARATOR;
    protected static final String TAB_STRING = "\t";
    protected boolean consoleLog = false;
    protected boolean newSession = true;
    protected File outFile;
    protected Writer writer;

    static {
        String s = System.getProperty("line.separator");
        LINE_SEPARATOR = s == null ? "\n" : s;
    }

    public EclipseLog(File outFile) {
        this.outFile = outFile;
        this.writer = null;
    }

    public EclipseLog(Writer writer) {
        this.writer = writer == null ? this.logForStream(System.err) : writer;
    }

    public EclipseLog() {
        this((Writer)null);
    }

    private Throwable getRoot(Throwable t) {
        Throwable deeplyNested;
        Throwable root = null;
        if (t instanceof BundleException) {
            root = ((BundleException)t).getNestedException();
        }
        if (t instanceof InvocationTargetException) {
            root = ((InvocationTargetException)t).getTargetException();
        }
        if ((root instanceof InvocationTargetException || root instanceof BundleException) && (deeplyNested = this.getRoot(root)) != null) {
            root = deeplyNested;
        }
        return root;
    }

    protected void writeSession() throws IOException {
        this.write(SESSION);
        this.writeSpace();
        String date = this.getDate();
        this.write(date);
        this.writeSpace();
        int i = SESSION.length() + date.length();
        while (i < 78) {
            this.write("-");
            ++i;
        }
        this.writeln();
        try {
            String key = "eclipse.buildId";
            String value = System.getProperty(key, "unknown");
            this.writeln(String.valueOf(key) + "=" + value);
            key = "java.fullversion";
            value = System.getProperty(key);
            if (value == null) {
                key = "java.version";
                value = System.getProperty(key);
                this.writeln(String.valueOf(key) + "=" + value);
                key = "java.vendor";
                value = System.getProperty(key);
                this.writeln(String.valueOf(key) + "=" + value);
            } else {
                this.writeln(String.valueOf(key) + "=" + value);
            }
        }
        catch (Exception exception) {}
        this.write("BootLoader constants: OS=" + EnvironmentInfo.getDefault().getOS());
        this.write(", ARCH=" + EnvironmentInfo.getDefault().getOSArch());
        this.write(", WS=" + EnvironmentInfo.getDefault().getWS());
        this.writeln(", NL=" + EnvironmentInfo.getDefault().getNL());
        String[] args = EnvironmentInfo.getDefault().getNonFrameworkArgs();
        if (args != null && args.length > 0) {
            this.write("Command-line arguments:");
            int i2 = 0;
            while (i2 < args.length) {
                if (i2 > 0 && PASSWORD.equals(args[i2 - 1])) {
                    this.write(" (omitted)");
                } else {
                    this.write(" " + args[i2]);
                }
                ++i2;
            }
            this.writeln();
        }
    }

    public void close() {
        try {
            if (this.writer != null) {
                Writer tmpWriter = this.writer;
                this.writer = null;
                tmpWriter.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected void openFile() {
        if (this.writer == null) {
            if (this.outFile != null) {
                try {
                    this.writer = this.logForStream(SecureAction.getFileOutputStream((File)this.outFile, (boolean)true));
                }
                catch (IOException iOException) {
                    this.writer = this.logForStream(System.err);
                }
            } else {
                this.writer = this.logForStream(System.err);
            }
        }
    }

    protected void closeFile() {
        if (this.outFile != null && this.writer != null) {
            try {
                this.writer.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.writer = null;
        }
    }

    public void log(FrameworkEvent frameworkEvent) {
        Bundle b = frameworkEvent.getBundle();
        Throwable t = frameworkEvent.getThrowable();
        FrameworkLogEntry logEntry = new FrameworkLogEntry(String.valueOf(b.getLocation()) + " 0 0", "FrameworkEvent.ERROR", 0, t, null);
        this.log(logEntry);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void log(FrameworkLogEntry logEntry) {
        if (logEntry == null) {
            return;
        }
        try {
            try {
                this.openFile();
                if (this.newSession) {
                    this.writeSession();
                    this.newSession = false;
                }
                this.writeLog(0, logEntry);
                this.writer.flush();
            }
            catch (Exception e) {
                System.err.println("An exception occurred while writing to the platform log:");
                e.printStackTrace(System.err);
                System.err.println("Logging to the console instead.");
                try {
                    this.writer = this.logForStream(System.err);
                    this.writeLog(0, logEntry);
                    this.writer.flush();
                }
                catch (Exception e2) {
                    System.err.println("An exception occurred while logging to the console:");
                    e2.printStackTrace(System.err);
                }
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.closeFile();
            throw throwable;
        }
        {
            Object var4_6 = null;
            this.closeFile();
            return;
        }
    }

    public synchronized void setWriter(Writer newWriter, boolean append) {
        this.setOutput(null, newWriter, append);
    }

    public synchronized void setFile(File newFile, boolean append) throws IOException {
        this.setOutput(newFile, null, append);
        System.getProperties().put("osgi.logfile", newFile.getAbsolutePath());
    }

    public synchronized File getFile() {
        return this.outFile;
    }

    public void setConsoleLog(boolean consoleLog) {
        this.consoleLog = consoleLog;
    }

    /*
     * Exception decompiling
     */
    private void setOutput(File newOutFile, Writer newWriter, boolean append) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 4[TRYBLOCK] [3 : 177->181)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void copyReader(Reader reader, Writer writer) throws IOException {
        int count;
        char[] buffer = new char[1024];
        while ((count = reader.read(buffer, 0, buffer.length)) > 0) {
            writer.write(buffer, 0, count);
        }
    }

    protected String getDate() {
        try {
            SimpleDateFormat formatter = new SimpleDateFormat("MMM dd, yyyy HH:mm:ss.SS");
            return formatter.format(new Date());
        }
        catch (Exception exception) {
            return Long.toString(System.currentTimeMillis());
        }
    }

    protected String getStackTrace(Throwable t) {
        if (t == null) {
            return null;
        }
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        t.printStackTrace(pw);
        Throwable root = this.getRoot(t);
        if (root != null) {
            pw.println("Root exception:");
            root.printStackTrace(pw);
        }
        return sw.toString();
    }

    protected Writer logForStream(OutputStream output) {
        try {
            return new BufferedWriter(new OutputStreamWriter(output, "UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return new BufferedWriter(new OutputStreamWriter(output));
        }
    }

    protected void writeLog(int depth, FrameworkLogEntry entry) throws IOException {
        this.writeEntry(depth, entry);
        this.writeMessage(entry);
        this.writeStack(entry);
        FrameworkLogEntry[] children = entry.getChildren();
        if (children != null) {
            int i = 0;
            while (i < children.length) {
                this.writeLog(depth + 1, children[i]);
                ++i;
            }
        }
    }

    protected void writeEntry(int depth, FrameworkLogEntry entry) throws IOException {
        if (depth == 0) {
            this.writeln();
            this.write(ENTRY);
        } else {
            this.write(SUBENTRY);
            this.writeSpace();
            this.write(Integer.toString(depth));
        }
        this.writeSpace();
        this.write(entry.getEntry());
        this.writeSpace();
        this.write(this.getDate());
        this.writeln();
    }

    protected void writeMessage(FrameworkLogEntry entry) throws IOException {
        this.write(MESSAGE);
        this.writeSpace();
        this.writeln(entry.getMessage());
    }

    protected void writeStack(FrameworkLogEntry entry) throws IOException {
        Throwable t = entry.getThrowable();
        if (t != null) {
            String stack = this.getStackTrace(t);
            this.write(STACK);
            this.writeSpace();
            this.write(Integer.toString(entry.getStackCode()));
            this.writeln();
            this.write(stack);
        }
    }

    protected void write(String message) throws IOException {
        if (message != null) {
            this.writer.write(message);
            if (this.consoleLog) {
                System.out.print(message);
            }
        }
    }

    protected void writeln(String s) throws IOException {
        this.write(s);
        this.writeln();
    }

    protected void writeln() throws IOException {
        this.write(LINE_SEPARATOR);
    }

    protected void writeSpace() throws IOException {
        this.write(" ");
    }
}

