/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.core;

import java.io.IOException;
import java.util.EventListener;
import java.util.List;
import org.eclipse.osgi.framework.debug.Debug;
import org.eclipse.osgi.framework.eventmgr.EventDispatcher;
import org.eclipse.osgi.framework.eventmgr.EventListeners;
import org.eclipse.osgi.framework.eventmgr.EventManager;
import org.eclipse.osgi.framework.eventmgr.ListenerQueue;
import org.eclipse.osgi.framework.internal.core.AbstractBundle;
import org.eclipse.osgi.framework.internal.core.BundleRepository;
import org.eclipse.osgi.framework.internal.core.Framework;
import org.eclipse.osgi.framework.internal.core.Msg;
import org.eclipse.osgi.framework.internal.core.StartLevelEvent;
import org.eclipse.osgi.framework.internal.core.StartLevelImpl;
import org.eclipse.osgi.framework.internal.core.Util;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceRegistration;

public class StartLevelManager
implements EventDispatcher,
EventListener,
ServiceFactory {
    protected static Framework framework;
    protected static EventManager eventManager;
    protected static EventListeners startLevelListeners;
    protected int frameworkBeginningStartLevel = 1;
    protected int initialBundleStartLevel = 1;
    private static int activeSL;
    private static final Object lock;

    static {
        activeSL = 0;
        lock = new Object();
    }

    protected StartLevelManager(Framework framework) {
        StartLevelManager.framework = framework;
    }

    protected void initialize() {
        this.initialBundleStartLevel = StartLevelManager.framework.adaptor.getInitialBundleStartLevel();
        String value = framework.getProperty("osgi.framework.beginningstartlevel");
        if (value == null) {
            value = "1";
        } else {
            try {
                if (Integer.parseInt(value) <= 0) {
                    System.err.println(Msg.formatter.getString("PROPERTIES_INVALID_FW_STARTLEVEL", "1"));
                    value = "1";
                }
            }
            catch (NumberFormatException numberFormatException) {
                System.err.println(Msg.formatter.getString("PROPERTIES_INVALID_FW_STARTLEVEL", "1"));
                value = "1";
            }
        }
        framework.setProperty("osgi.framework.beginningstartlevel", value);
        this.frameworkBeginningStartLevel = Integer.parseInt(value);
        eventManager = new EventManager("Start Level Event Dispatcher");
        startLevelListeners = new EventListeners();
        startLevelListeners.addListener(this, this);
    }

    protected void cleanup() {
        eventManager.close();
        eventManager = null;
        startLevelListeners.removeAllListeners();
        startLevelListeners = null;
    }

    public int getInitialBundleStartLevel() {
        return this.initialBundleStartLevel;
    }

    public int getFrameworkStartLevel() {
        return this.frameworkBeginningStartLevel;
    }

    public void setInitialBundleStartLevel(int startlevel) {
        framework.checkAdminPermission();
        if (startlevel <= 0) {
            throw new IllegalArgumentException();
        }
        this.initialBundleStartLevel = startlevel;
        StartLevelManager.framework.adaptor.setInitialBundleStartLevel(startlevel);
    }

    public int getStartLevel() {
        return activeSL;
    }

    public void setStartLevel(int newSL, Bundle callerBundle) {
        if (newSL <= 0) {
            throw new IllegalArgumentException(Msg.formatter.getString("STARTLEVEL_EXCEPTION_INVALID_REQUESTED_STARTLEVEL", "" + newSL));
        }
        framework.checkAdminPermission();
        if (Debug.DEBUG_STARTLEVEL) {
            Debug.println("StartLevelImpl: setStartLevel: " + newSL + "; callerBundle = " + callerBundle.getBundleId());
        }
        this.issueEvent(new StartLevelEvent(1, newSL, (AbstractBundle)callerBundle));
    }

    protected void setStartLevel(int newSL) {
        this.setStartLevel(newSL, StartLevelManager.framework.systemBundle);
    }

    protected void launch(int startlevel) {
        this.doSetStartLevel(startlevel, StartLevelManager.framework.systemBundle);
    }

    protected void shutdown() {
        this.doSetStartLevel(0, StartLevelManager.framework.systemBundle);
    }

    private void doSetStartLevel(int newSL, AbstractBundle callerBundle) {
        Object object = lock;
        synchronized (object) {
            int tempSL = activeSL;
            if (newSL > tempSL) {
                int i = tempSL;
                while (i < newSL) {
                    if (Debug.DEBUG_STARTLEVEL) {
                        Debug.println("sync - incrementing Startlevel from " + tempSL);
                    }
                    ++tempSL;
                    this.incFWSL(i + 1, callerBundle);
                    ++i;
                }
            } else {
                int i = tempSL;
                while (i > newSL) {
                    if (Debug.DEBUG_STARTLEVEL) {
                        Debug.println("sync - decrementing Startlevel from " + tempSL);
                    }
                    --tempSL;
                    this.decFWSL(i - 1);
                    --i;
                }
            }
            framework.publishFrameworkEvent(8, callerBundle, null);
            if (Debug.DEBUG_STARTLEVEL) {
                Debug.println("StartLevelImpl: doSetStartLevel: STARTLEVEL_CHANGED event published");
            }
        }
    }

    protected void saveActiveStartLevel(int newSL) {
        Object object = lock;
        synchronized (object) {
            activeSL = newSL;
        }
    }

    public boolean isBundlePersistentlyStarted(Bundle bundle) {
        if (bundle.getState() == 1) {
            throw new IllegalArgumentException(Msg.formatter.getString("BUNDLE_UNINSTALLED_EXCEPTION"));
        }
        AbstractBundle b = (AbstractBundle)bundle;
        int status = b.getBundleData().getStatus();
        return (status & 1) == 1;
    }

    public int getBundleStartLevel(Bundle bundle) {
        if (bundle.getState() == 1) {
            throw new IllegalArgumentException(Msg.formatter.getString("BUNDLE_UNINSTALLED_EXCEPTION"));
        }
        return ((AbstractBundle)bundle).getStartLevel();
    }

    public void setBundleStartLevel(Bundle bundle, int newSL) {
        String exceptionText = "";
        if (bundle.getBundleId() == 0L) {
            exceptionText = Msg.formatter.getString("STARTLEVEL_CANT_CHANGE_SYSTEMBUNDLE_STARTLEVEL");
        } else if (bundle.getState() == 1) {
            exceptionText = Msg.formatter.getString("BUNDLE_UNINSTALLED_EXCEPTION");
        } else if (newSL <= 0) {
            exceptionText = Msg.formatter.getString("STARTLEVEL_EXCEPTION_INVALID_REQUESTED_STARTLEVEL", "" + newSL);
        }
        if (exceptionText.length() > 0) {
            throw new IllegalArgumentException(exceptionText);
        }
        try {
            if (newSL != ((AbstractBundle)bundle).getStartLevel()) {
                AbstractBundle b = (AbstractBundle)bundle;
                b.getBundleData().setStartLevel(newSL);
                b.getBundleData().save();
                framework.checkAdminPermission();
                this.issueEvent(new StartLevelEvent(0, newSL, (AbstractBundle)bundle));
            }
        }
        catch (IOException e) {
            framework.publishFrameworkEvent(2, bundle, e);
        }
    }

    private void issueEvent(StartLevelEvent sle) {
        ListenerQueue queue = new ListenerQueue(eventManager);
        queue.queueListeners(startLevelListeners, this);
        queue.dispatchEventAsynchronous(sle.getType(), sle);
    }

    public void dispatchEvent(Object listener, Object listenerObject, int eventAction, Object eventObject) {
        try {
            switch (eventAction) {
                case 0: {
                    this.setBundleSL((StartLevelEvent)eventObject);
                    break;
                }
                case 1: {
                    this.doSetStartLevel(((StartLevelEvent)eventObject).getNewSL(), ((StartLevelEvent)eventObject).getBundle());
                }
            }
        }
        catch (Throwable t) {
            StartLevelManager.framework.adaptor.handleRuntimeError(t);
        }
    }

    protected void incFWSL(int activeSL, AbstractBundle callerBundle) {
        if (Debug.DEBUG_STARTLEVEL) {
            Debug.println("SLL: incFWSL: saving activeSL of " + activeSL);
        }
        StartLevelManager.framework.startLevelManager.saveActiveStartLevel(activeSL);
        BundleRepository bundles = StartLevelManager.framework.bundles;
        AbstractBundle[] launch = this.getInstalledBundles(bundles);
        if (activeSL == 1) {
            this.loadInstalledBundles(launch);
            StartLevelManager.framework.packageAdmin.setResolvedBundles();
            this.resumeBundles(launch, true);
            if (Debug.DEBUG_STARTLEVEL) {
                Debug.println("SLL: Framework started");
            }
            framework.publishFrameworkEvent(1, callerBundle, null);
        } else {
            this.resumeBundles(launch, false);
        }
    }

    private AbstractBundle[] getInstalledBundles(BundleRepository bundles) {
        Object[] installedBundles;
        BundleRepository bundleRepository = bundles;
        synchronized (bundleRepository) {
            List allBundles = bundles.getBundles();
            installedBundles = new AbstractBundle[allBundles.size()];
            allBundles.toArray(installedBundles);
            Util.sort(installedBundles, 0, installedBundles.length);
        }
        return installedBundles;
    }

    private void loadInstalledBundles(AbstractBundle[] installedBundles) {
        int i = 0;
        while (i < installedBundles.length) {
            AbstractBundle bundle = installedBundles[i];
            try {
                if (Debug.DEBUG_STARTLEVEL) {
                    Debug.println("SLL: Trying to load bundle " + bundle);
                }
                bundle.load();
            }
            catch (BundleException be) {
                if (Debug.DEBUG_STARTLEVEL) {
                    Debug.println("SLL: Bundle load exception: " + be.getMessage());
                    Debug.printStackTrace(be.getNestedException());
                }
                framework.publishFrameworkEvent(2, bundle, be);
            }
            ++i;
        }
    }

    private void resumeBundles(AbstractBundle[] launch, boolean launchingFW) {
        if (launchingFW) {
            try {
                StartLevelManager.framework.systemBundle.context.start();
            }
            catch (BundleException be) {
                if (Debug.DEBUG_STARTLEVEL) {
                    Debug.println("SLL: Bundle resume exception: " + be.getMessage());
                    Debug.printStackTrace(be.getNestedException());
                }
                framework.publishFrameworkEvent(2, StartLevelManager.framework.systemBundle, be);
                throw new RuntimeException(be.getMessage());
            }
        }
        int fwsl = StartLevelManager.framework.startLevelManager.getStartLevel();
        int i = 0;
        while (i < launch.length) {
            int bsl = launch[i].getStartLevel();
            if (bsl >= fwsl) {
                if (bsl != fwsl) break;
                if (Debug.DEBUG_STARTLEVEL) {
                    Debug.println("SLL: Active sl = " + fwsl + "; Bundle " + launch[i].getBundleId() + " sl = " + bsl);
                }
                framework.resumeBundle(launch[i]);
            }
            ++i;
        }
        StartLevelManager.framework.systemBundle.state = 32;
    }

    protected void decFWSL(int activeSL) {
        if (Debug.DEBUG_STARTLEVEL) {
            Debug.println("SLL: decFWSL: saving activeSL of " + activeSL);
        }
        StartLevelManager.framework.startLevelManager.saveActiveStartLevel(activeSL);
        BundleRepository bundles = StartLevelManager.framework.bundles;
        if (activeSL == 0) {
            this.suspendAllBundles(bundles);
            this.unloadAllBundles(bundles);
        } else {
            BundleRepository bundleRepository = bundles;
            synchronized (bundleRepository) {
                AbstractBundle[] shutdown = this.getInstalledBundles(bundles);
                int i = shutdown.length - 1;
                while (i >= 0) {
                    int bsl = shutdown[i].getStartLevel();
                    if (bsl <= activeSL + 1) {
                        if (bsl <= activeSL) break;
                        if (shutdown[i].isActive()) {
                            if (Debug.DEBUG_STARTLEVEL) {
                                Debug.println("SLL: stopping bundle " + shutdown[i].getBundleId());
                            }
                            framework.suspendBundle(shutdown[i], false);
                        }
                    }
                    --i;
                }
            }
        }
    }

    private void suspendAllBundles(BundleRepository bundles) {
        BundleRepository bundleRepository = bundles;
        synchronized (bundleRepository) {
            boolean changed;
            do {
                changed = false;
                AbstractBundle[] shutdown = this.getInstalledBundles(bundles);
                int i = shutdown.length - 1;
                while (i >= 0) {
                    AbstractBundle bundle = shutdown[i];
                    if (framework.suspendBundle(bundle, false)) {
                        if (Debug.DEBUG_STARTLEVEL) {
                            Debug.println("SLL: stopped bundle " + bundle.getBundleId());
                        }
                        changed = true;
                    }
                    --i;
                }
            } while (changed);
            try {
                StartLevelManager.framework.systemBundle.context.stop();
            }
            catch (BundleException sbe) {
                if (Debug.DEBUG_STARTLEVEL) {
                    Debug.println("SLL: Bundle suspend exception: " + sbe.getMessage());
                    Debug.printStackTrace(sbe.getNestedException());
                }
                framework.publishFrameworkEvent(2, StartLevelManager.framework.systemBundle, sbe);
            }
            StartLevelManager.framework.systemBundle.state = 8;
        }
    }

    private void unloadAllBundles(BundleRepository bundles) {
        BundleRepository bundleRepository = bundles;
        synchronized (bundleRepository) {
            List allBundles = bundles.getBundles();
            int size = allBundles.size();
            int i = 0;
            while (i < size) {
                AbstractBundle bundle = (AbstractBundle)allBundles.get(i);
                if (Debug.DEBUG_STARTLEVEL) {
                    Debug.println("SLL: Trying to unload bundle " + bundle);
                }
                try {
                    bundle.refresh();
                }
                catch (BundleException bundleException) {}
                ++i;
            }
        }
    }

    protected void setBundleSL(StartLevelEvent startLevelEvent) {
        Object object = lock;
        synchronized (object) {
            int activeSL = StartLevelManager.framework.startLevelManager.getStartLevel();
            int newSL = startLevelEvent.getNewSL();
            AbstractBundle bundle = startLevelEvent.getBundle();
            bundle.getState();
            if (Debug.DEBUG_STARTLEVEL) {
                Debug.print("SLL: bundle active=" + bundle.isActive());
                Debug.print("; newSL = " + newSL);
                Debug.println("; activeSL = " + activeSL);
            }
            if (bundle.isActive() && newSL > activeSL) {
                if (Debug.DEBUG_STARTLEVEL) {
                    Debug.println("SLL: stopping bundle " + bundle.getBundleId());
                }
                framework.suspendBundle(bundle, false);
            } else if (!bundle.isActive() && newSL <= activeSL) {
                if (Debug.DEBUG_STARTLEVEL) {
                    Debug.println("SLL: starting bundle " + bundle.getBundleId());
                }
                framework.resumeBundle(bundle);
            }
            if (Debug.DEBUG_STARTLEVEL) {
                Debug.println("SLL: Bundle Startlevel set to " + newSL);
            }
        }
    }

    public Object getService(Bundle owner, ServiceRegistration registration) {
        return new StartLevelImpl(owner, framework);
    }

    public void ungetService(Bundle owner, ServiceRegistration registration, Object service) {
    }
}

