/*
 * Decompiled with CFR 0.152.
 */
package mpplayer.win32.wmp;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class WmpDispId {
    public static final CurrentMedia currentMedia = new CurrentMedia();
    public static final NewMedia newMedia = new NewMedia();
    public static final Controls controls = new Controls();
    public static final PlayState playState = new PlayState();
    private static Map _name2ItemMap;
    private static Map _value2ItemMap;
    private static List _all;

    protected WmpDispId() {
    }

    public String toString() {
        return this.getName();
    }

    public abstract String getName();

    public abstract int getValue();

    public static WmpDispId valueOf(String name, WmpDispId defaultValue) {
        Map map = WmpDispId.getName2ItemMap();
        WmpDispId item = map.containsKey(name) ? (WmpDispId)map.get(name) : defaultValue;
        return item;
    }

    public static WmpDispId valueOf(String name) {
        WmpDispId i_t_e_m = WmpDispId.valueOf(name, null);
        if (i_t_e_m == null) {
            throw new IllegalArgumentException("name not in enumeration: " + name);
        }
        return i_t_e_m;
    }

    public static WmpDispId valueOf(int value) {
        WmpDispId item = WmpDispId.valueOf(value, null);
        if (item == null) {
            throw new IllegalArgumentException("value not in enumeration: " + value);
        }
        return item;
    }

    public static WmpDispId valueOf(int value, WmpDispId defaultValue) {
        Integer aValue = new Integer(value);
        Map map = WmpDispId.getValue2ItemMap();
        WmpDispId item = map.containsKey(aValue) ? (WmpDispId)map.get(aValue) : defaultValue;
        return item;
    }

    protected final Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    protected static Map getName2ItemMap() {
        if (_name2ItemMap == null) {
            HashMap<String, WmpDispId> map = new HashMap<String, WmpDispId>();
            Iterator all = WmpDispId.getAll().iterator();
            while (all.hasNext()) {
                WmpDispId item = (WmpDispId)all.next();
                map.put(item.getName(), item);
            }
            _name2ItemMap = map;
        }
        return _name2ItemMap;
    }

    protected static Map getValue2ItemMap() {
        if (_value2ItemMap == null) {
            HashMap<Integer, WmpDispId> map = new HashMap<Integer, WmpDispId>();
            Iterator all = WmpDispId.getAll().iterator();
            while (all.hasNext()) {
                WmpDispId item = (WmpDispId)all.next();
                map.put(new Integer(item.getValue()), item);
            }
            _value2ItemMap = map;
        }
        return _value2ItemMap;
    }

    public boolean isCurrentMedia() {
        return this.equals(currentMedia);
    }

    public boolean isNewMedia() {
        return this.equals(newMedia);
    }

    public boolean isControls() {
        return this.equals(controls);
    }

    public boolean isPlayState() {
        return this.equals(playState);
    }

    public static List getAll() {
        if (_all == null) {
            _all = Arrays.asList(currentMedia, newMedia, controls, playState);
        }
        return _all;
    }

    public static class CurrentMedia
    extends WmpDispId {
        protected CurrentMedia() {
        }

        public String getName() {
            return "currentMedia";
        }

        public int getValue() {
            return 6;
        }
    }

    public static class NewMedia
    extends WmpDispId {
        protected NewMedia() {
        }

        public String getName() {
            return "newMedia";
        }

        public int getValue() {
            return 42;
        }
    }

    public static class Controls
    extends WmpDispId {
        protected Controls() {
        }

        public String getName() {
            return "controls";
        }

        public int getValue() {
            return 4;
        }
    }

    public static class PlayState
    extends WmpDispId {
        protected PlayState() {
        }

        public String getName() {
            return "playState";
        }

        public int getValue() {
            return 10;
        }
    }
}

