/*
 * Decompiled with CFR 0.152.
 */
package mpplayer.win32.wmp;

import mpplayer.ExternalPlayer;
import mpplayer.MpplayerException;
import mpplayer.PlayState;
import mpplayer.PlayerListeners;
import mpplayer.win32.AbstractOlePlayer;
import mpplayer.win32.wmp.Controls;
import mpplayer.win32.wmp.Media;
import mpplayer.win32.wmp.WmpDispId;
import mpplayer.win32.wmp.WmpEvent;
import mpplayer.win32.wmp.WmpPlayState;
import org.eclipse.swt.ole.win32.OleEvent;
import org.eclipse.swt.ole.win32.OleListener;
import org.eclipse.swt.ole.win32.Variant;
import org.eclipse.swt.widgets.Composite;

public class Wmp
extends AbstractOlePlayer {
    public Wmp(Composite parent, int style, String progId) {
        super(parent, style, progId);
        this.getSite().addEventListener(WmpEvent.playStateChange.getValue(), new OleListener(){

            public void handleEvent(OleEvent event) {
                Wmp.this.onPlayStateChange(event);
            }
        });
    }

    public Controls getControls() {
        return new Controls(this.getControl().getProperty(WmpDispId.controls.getValue()).getAutomation());
    }

    public Media getCurrentMedia() {
        return new Media(this.getControl().getProperty(WmpDispId.currentMedia.getValue()).getAutomation());
    }

    public void setCurrentMedia(Media media) {
        this.getControl().setProperty(WmpDispId.currentMedia.getValue(), new Variant(media.getDelegate()));
    }

    public Media newMedia(String file) {
        Variant newMedia = this.getControl().invoke(WmpDispId.newMedia.getValue(), new Variant[]{new Variant(file)});
        if (newMedia == null) {
            throw new MpplayerException("The Media could not be loaded.");
        }
        return new Media(newMedia.getAutomation());
    }

    protected void onPlayStateChange(OleEvent event) {
        if (event.arguments[0].getInt() == WmpPlayState.mediaEnded.getValue()) {
            PlayerListeners.Iterator lss = this.getListeners().iterator();
            while (lss.hasNext()) {
                lss.next().onMediaEnded();
            }
        }
    }

    public void load(String media) {
        this.setCurrentMedia(this.newMedia(media));
    }

    public void play() {
        this.getControls().play();
    }

    public void pause() {
        this.getControls().pause();
    }

    public void stop() {
        this.getControls().stop();
    }

    public float getPlayPosition() {
        return this.getControls().getCurrentPosition();
    }

    public void setCurrentPlayPosition(float position) {
        this.getControls().setCurrentPosition(position);
    }

    public PlayState getPlayState() {
        PlayState ps;
        try {
            ps = WmpPlayState.valueOf(this.getControl().getProperty(WmpDispId.playState.getValue()).getInt()).toPlayState();
        }
        catch (Exception exception) {
            ps = PlayState.undefined;
        }
        return ps;
    }

    public float getCurrentMediaDuration() {
        return this.getCurrentMedia().getDuration();
    }

    public String getTitle() {
        return ExternalPlayer.wmp.getTitle();
    }
}

