/*
 * Decompiled with CFR 0.152.
 */
package mpplayer.win32.wmp;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class MediaDispId {
    public static final Duration duration = new Duration();
    public static final LotsMoreToCome lotsMoreToCome = new LotsMoreToCome();
    private static Map _name2ItemMap;
    private static Map _value2ItemMap;
    private static List _all;

    protected MediaDispId() {
    }

    public String toString() {
        return this.getName();
    }

    public abstract String getName();

    public abstract int getValue();

    public static MediaDispId valueOf(String name, MediaDispId defaultValue) {
        Map map = MediaDispId.getName2ItemMap();
        MediaDispId item = map.containsKey(name) ? (MediaDispId)map.get(name) : defaultValue;
        return item;
    }

    public static MediaDispId valueOf(String name) {
        MediaDispId i_t_e_m = MediaDispId.valueOf(name, null);
        if (i_t_e_m == null) {
            throw new IllegalArgumentException("name not in enumeration: " + name);
        }
        return i_t_e_m;
    }

    public static MediaDispId valueOf(int value) {
        MediaDispId item = MediaDispId.valueOf(value, null);
        if (item == null) {
            throw new IllegalArgumentException("value not in enumeration: " + value);
        }
        return item;
    }

    public static MediaDispId valueOf(int value, MediaDispId defaultValue) {
        Integer aValue = new Integer(value);
        Map map = MediaDispId.getValue2ItemMap();
        MediaDispId item = map.containsKey(aValue) ? (MediaDispId)map.get(aValue) : defaultValue;
        return item;
    }

    protected final Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    protected static Map getName2ItemMap() {
        if (_name2ItemMap == null) {
            HashMap<String, MediaDispId> map = new HashMap<String, MediaDispId>();
            Iterator all = MediaDispId.getAll().iterator();
            while (all.hasNext()) {
                MediaDispId item = (MediaDispId)all.next();
                map.put(item.getName(), item);
            }
            _name2ItemMap = map;
        }
        return _name2ItemMap;
    }

    protected static Map getValue2ItemMap() {
        if (_value2ItemMap == null) {
            HashMap<Integer, MediaDispId> map = new HashMap<Integer, MediaDispId>();
            Iterator all = MediaDispId.getAll().iterator();
            while (all.hasNext()) {
                MediaDispId item = (MediaDispId)all.next();
                map.put(new Integer(item.getValue()), item);
            }
            _value2ItemMap = map;
        }
        return _value2ItemMap;
    }

    public boolean isDuration() {
        return this.equals(duration);
    }

    public boolean isLotsMoreToCome() {
        return this.equals(lotsMoreToCome);
    }

    public static List getAll() {
        if (_all == null) {
            _all = Arrays.asList(duration, lotsMoreToCome);
        }
        return _all;
    }

    public static class Duration
    extends MediaDispId {
        protected Duration() {
        }

        public String getName() {
            return "duration";
        }

        public int getValue() {
            return 757;
        }
    }

    public static class LotsMoreToCome
    extends MediaDispId {
        protected LotsMoreToCome() {
        }

        public String getName() {
            return "lotsMoreToCome";
        }

        public int getValue() {
            return 12345;
        }
    }
}

