/*
 * Decompiled with CFR 0.152.
 */
package mpplayer.win32.realone;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import mpplayer.PlayState;

public abstract class RealOnePlayState {
    public static final Undefined undefined = new Undefined();
    public static final Stopped stopped = new Stopped();
    public static final Paused paused = new Paused();
    public static final Playing playing = new Playing();
    private static Map _name2ItemMap;
    private static Map _value2ItemMap;
    private static List _all;

    protected RealOnePlayState() {
    }

    public String toString() {
        return this.getName();
    }

    public abstract String getName();

    public abstract int getValue();

    public static RealOnePlayState valueOf(String name, RealOnePlayState defaultValue) {
        Map map = RealOnePlayState.getName2ItemMap();
        RealOnePlayState item = map.containsKey(name) ? (RealOnePlayState)map.get(name) : defaultValue;
        return item;
    }

    public static RealOnePlayState valueOf(String name) {
        RealOnePlayState i_t_e_m = RealOnePlayState.valueOf(name, null);
        if (i_t_e_m == null) {
            throw new IllegalArgumentException("name not in enumeration: " + name);
        }
        return i_t_e_m;
    }

    public static RealOnePlayState valueOf(int value) {
        RealOnePlayState item = RealOnePlayState.valueOf(value, null);
        if (item == null) {
            throw new IllegalArgumentException("value not in enumeration: " + value);
        }
        return item;
    }

    public static RealOnePlayState valueOf(int value, RealOnePlayState defaultValue) {
        Integer aValue = new Integer(value);
        Map map = RealOnePlayState.getValue2ItemMap();
        RealOnePlayState item = map.containsKey(aValue) ? (RealOnePlayState)map.get(aValue) : defaultValue;
        return item;
    }

    protected final Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    protected static Map getName2ItemMap() {
        if (_name2ItemMap == null) {
            HashMap<String, RealOnePlayState> map = new HashMap<String, RealOnePlayState>();
            Iterator all = RealOnePlayState.getAll().iterator();
            while (all.hasNext()) {
                RealOnePlayState item = (RealOnePlayState)all.next();
                map.put(item.getName(), item);
            }
            _name2ItemMap = map;
        }
        return _name2ItemMap;
    }

    protected static Map getValue2ItemMap() {
        if (_value2ItemMap == null) {
            HashMap<Integer, RealOnePlayState> map = new HashMap<Integer, RealOnePlayState>();
            Iterator all = RealOnePlayState.getAll().iterator();
            while (all.hasNext()) {
                RealOnePlayState item = (RealOnePlayState)all.next();
                map.put(new Integer(item.getValue()), item);
            }
            _value2ItemMap = map;
        }
        return _value2ItemMap;
    }

    public boolean isUndefined() {
        return this.equals(undefined);
    }

    public boolean isStopped() {
        return this.equals(stopped);
    }

    public boolean isPaused() {
        return this.equals(paused);
    }

    public boolean isPlaying() {
        return this.equals(playing);
    }

    public static List getAll() {
        if (_all == null) {
            _all = Arrays.asList(undefined, stopped, paused, playing);
        }
        return _all;
    }

    public PlayState toPlayState() {
        PlayState ps = this.isStopped() ? PlayState.stopped : (this.isPlaying() ? PlayState.playing : (this.isPaused() ? PlayState.paused : PlayState.undefined));
        return ps;
    }

    public static class Undefined
    extends RealOnePlayState {
        protected Undefined() {
        }

        public String getName() {
            return "undefined";
        }

        public int getValue() {
            return 0;
        }
    }

    public static class Stopped
    extends RealOnePlayState {
        protected Stopped() {
        }

        public String getName() {
            return "stopped";
        }

        public int getValue() {
            return 1;
        }
    }

    public static class Paused
    extends RealOnePlayState {
        protected Paused() {
        }

        public String getName() {
            return "paused";
        }

        public int getValue() {
            return 2;
        }
    }

    public static class Playing
    extends RealOnePlayState {
        protected Playing() {
        }

        public String getName() {
            return "playing";
        }

        public int getValue() {
            return 3;
        }
    }
}

