/*
 * Decompiled with CFR 0.152.
 */
package mpplayer.win32;

import java.text.MessageFormat;
import mpplayer.IPlayer;
import mpplayer.IPlayerListener;
import mpplayer.MpplayerException;
import mpplayer.PlayerListeners;
import org.eclipse.swt.ole.win32.OleAutomation;
import org.eclipse.swt.ole.win32.OleClientSite;
import org.eclipse.swt.ole.win32.OleControlSite;
import org.eclipse.swt.ole.win32.OleFrame;
import org.eclipse.swt.widgets.Composite;

public abstract class AbstractOlePlayer
implements IPlayer {
    private PlayerListeners _listeners;
    private OleAutomation _control;
    private OleControlSite _site;
    private Composite _frame;

    public AbstractOlePlayer(Composite parent, int style, String progId) {
        try {
            OleFrame oleFrame = new OleFrame(parent, style);
            this.setFrame((Composite)oleFrame);
            OleControlSite site = new OleControlSite((Composite)oleFrame, 0, progId);
            this.setSite(site);
            this.setControl(new OleAutomation((OleClientSite)site));
        }
        catch (Exception e) {
            String text = MessageFormat.format("An error occured while embedding \"{0}\" which is required to run this application.\n\nThe system says: {1}", progId, String.valueOf(e.getMessage()));
            throw new MpplayerException(text);
        }
    }

    public PlayerListeners getListeners() {
        if (this._listeners == null) {
            this._listeners = new PlayerListeners();
        }
        return this._listeners;
    }

    public void addPlayerListener(IPlayerListener listener) {
        this.getListeners().add(listener);
    }

    public void removePlayerListener(IPlayerListener listener) {
        this.getListeners().remove(listener);
    }

    public OleAutomation getControl() {
        return this._control;
    }

    public Composite getFrame() {
        return this._frame;
    }

    public OleControlSite getSite() {
        return this._site;
    }

    protected void setControl(OleAutomation control) {
        this._control = control;
    }

    protected void setFrame(Composite frame) {
        this._frame = frame;
    }

    protected void setSite(OleControlSite site) {
        this._site = site;
    }

    public void dispose() {
        this.getControl().dispose();
    }
}

