/*
 * Decompiled with CFR 0.152.
 */
package mpplayer.widgets;

import java.util.Iterator;
import java.util.List;
import mpplayer.widgets.IScaleContentProvider;
import mpplayer.widgets.SelectionListeners;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;

public class Scale
extends Composite {
    public static final Object SELECTION = new Object();
    private ScaleViewer _viewer;
    private SelectionListeners _selectionListeners;
    private IScaleContentProvider _contentProvider;
    private ILabelProvider _labelProvider;
    private Object _input;
    public static final int GAP = 0;
    private Integer _selection;
    private Integer _max;

    public Scale(Composite parent, int style) {
        super(parent, style);
        this.init();
    }

    public int markerAtSelection(int selection) {
        int x = this.selectionToX(selection);
        int result = -1;
        int x1 = x - 4;
        int x2 = x + 4;
        if (this.hasContentProvider()) {
            IScaleContentProvider cp = this.getContentProvider();
            List markers = cp.getMarkers(this.getInput());
            int i = 0;
            int n = markers.size();
            while (i < n && result == -1) {
                String nr = markers.get(i).toString();
                int pos = (int)new Double(nr).doubleValue();
                int markerX = this.selectionToX(pos);
                if (markerX >= x1 && markerX <= x2) {
                    result = i;
                }
                ++i;
            }
        }
        return result;
    }

    protected void onMouseDown(MouseEvent e) {
        if (e.button == 1) {
            int currSel;
            boolean scaleClicked = e.y < this._viewer.getScaleHeight();
            int newSel = this.xToSelection(e.x);
            if (newSel != (currSel = this.getSelection())) {
                if (!scaleClicked) {
                    this.setSelection(newSel);
                }
                Event aSe = new Event();
                aSe.detail = scaleClicked ? 1 : 0;
                aSe.data = new Integer(newSel);
                aSe.widget = this;
                SelectionEvent se = new SelectionEvent(aSe);
                SelectionListeners.Iterator lss = this.getSelectionListeners().iterator();
                while (lss.hasNext()) {
                    lss.next().widgetSelected(se);
                }
            }
        }
    }

    public int xToSelection(int x) {
        return this.narrow((int)((float)this.getMax() * (float)(x - 0) / (float)this.gappedWidth()));
    }

    protected int narrow(int sel) {
        int max = this.getMax();
        if (sel < 0) {
            sel = 0;
        } else if (sel > max) {
            sel = max;
        }
        return sel;
    }

    protected int gappedWidth() {
        return this.getBounds().width - 0;
    }

    public int selectionToX(int selection) {
        return 0 + (int)((float)this.gappedWidth() / (float)this.getMax() * (float)selection);
    }

    protected void init() {
        this.setLayout((Layout)new FillLayout());
        ScaleViewer viewer = new ScaleViewer(this, 0);
        viewer.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                Scale.this.onMouseDown(e);
            }

            public void mouseUp(MouseEvent e) {
            }
        });
        this._viewer = viewer;
    }

    public void refresh() {
        if (!this.isDisposed()) {
            this._viewer.redraw();
        }
    }

    public boolean setFocus() {
        return super.setFocus();
    }

    public void addSelectionListener(SelectionListener listener) {
        this.getSelectionListeners().add(listener);
    }

    public SelectionListeners getSelectionListeners() {
        if (this._selectionListeners == null) {
            this._selectionListeners = new SelectionListeners();
        }
        return this._selectionListeners;
    }

    public int getSelection() {
        if (this._selection == null) {
            this._selection = new Integer(0);
        }
        return this._selection;
    }

    public void setSelection(int selection) {
        Integer aSelection = new Integer(selection = this.narrow(selection));
        if (!aSelection.equals(this._selection)) {
            this._selection = aSelection;
            this.refresh();
        }
    }

    public int getMax() {
        if (this._max == null) {
            this._max = new Integer(0);
        }
        return this._max;
    }

    public void setMax(int max) {
        Integer aMax = new Integer(max);
        if (!aMax.equals(this._max)) {
            this._max = aMax;
            this.refresh();
        }
    }

    public IScaleContentProvider getContentProvider() {
        return this._contentProvider;
    }

    public boolean hasContentProvider() {
        return this.getContentProvider() != null;
    }

    public void setContentProvider(IScaleContentProvider contentProvider) {
        this._contentProvider = contentProvider;
        this.refresh();
    }

    public ILabelProvider getLabelProvider() {
        return this._labelProvider;
    }

    public boolean hasLabelProvider() {
        return this.getLabelProvider() != null;
    }

    public void setLabelProvider(ILabelProvider labelProvider) {
        this._labelProvider = labelProvider;
    }

    public Object getInput() {
        return this._input;
    }

    public boolean hasInput() {
        return this.getInput() != null;
    }

    public void setInput(Object input) {
        this._input = input;
        this.refresh();
    }

    public class ScaleViewer
    extends Canvas
    implements PaintListener {
        private Integer _scaleHeight;

        public ScaleViewer(Composite parent, int style) {
            super(parent, style);
            this.setBackground(ColorConstants.listBackground);
            this.init();
        }

        void init() {
            this.addPaintListener(this);
        }

        public void dispose() {
            super.dispose();
        }

        public void paintControl(PaintEvent e) {
            GC gc = e.gc;
            Rectangle b = this.getBounds();
            int indicatorTop = b.y;
            boolean hasLp = Scale.this.hasLabelProvider();
            ILabelProvider lp = Scale.this.getLabelProvider();
            if (Scale.this.hasContentProvider() && Scale.this.getMax() > 0) {
                int fontHeight = this.getScaleHeight();
                indicatorTop += fontHeight;
                gc.setBackground(ColorConstants.titleBackground);
                gc.fillRectangle(0, 0, b.width, fontHeight);
                gc.setForeground(ColorConstants.buttonLightest);
                gc.drawLine(0, 0, b.width, 0);
                gc.drawLine(0, 0, 0, fontHeight);
                gc.setForeground(ColorConstants.buttonDarkest);
                gc.drawLine(0, fontHeight, b.width, fontHeight);
                gc.drawLine(0, b.y + b.height - 1, b.width, b.y + b.height - 1);
                gc.setForeground(ColorConstants.titleForeground);
                IScaleContentProvider cp = Scale.this.getContentProvider();
                Iterator markers = cp.getMarkers(Scale.this.getInput()).iterator();
                while (markers.hasNext()) {
                    Object marker = markers.next();
                    String nr = marker.toString();
                    double pos = new Double(nr);
                    if (hasLp) {
                        nr = lp.getText(marker);
                    }
                    int aX = Scale.this.selectionToX((int)pos);
                    gc.drawText(nr, aX + 1, b.y, true);
                    int scaleBottom = b.y + fontHeight;
                    gc.drawLine(aX, scaleBottom - 4, aX, b.y + scaleBottom);
                }
            }
            int x = Scale.this.selectionToX(Scale.this.getSelection());
            gc.setForeground(ColorConstants.black);
            gc.drawLine(x, indicatorTop + 1, x, b.height);
        }

        public int getScaleHeight() {
            if (this._scaleHeight == null) {
                GC gc = new GC((Drawable)this);
                int h = gc.textExtent((String)"M").y;
                gc.dispose();
                this._scaleHeight = new Integer(h);
            }
            return this._scaleHeight;
        }
    }
}

