/*
 * Decompiled with CFR 0.152.
 */
package mpplayer.model;

import com.o3tt3rli.xml.XmlNode;
import com.o3tt3rli.xml.XmlNodes;
import java.io.File;
import java.util.Iterator;
import mpplayer.Command;
import mpplayer.ExternalPlayer;
import mpplayer.model.Player;
import mpplayer.model.Players;
import org.dom4j.Element;

public class SettingsDocument {
    public static final int DEFAULT_JOYSTICK_SPEED = 3;
    public static final int DEFAULT_JOYSTICK_INTERVAL = 800;
    public static final String SETTINGS_FILE = "settings.xml";
    private XmlNode _delegate;

    public static SettingsDocument create() {
        XmlNode settings = new XmlNode("settings");
        settings.add("autoCommandFocus").setValue(String.valueOf(true));
        settings.add("joystickEnabled").setValue(String.valueOf(false));
        settings.add("joystickLeftCommand").setValue(Command.backToLastMarker.getName());
        settings.add("joystickRightCommand").setValue(Command.nextMarker.getName());
        settings.add("joystickUpCommand").setValue(Command.previousTrack.getName());
        settings.add("joystickDownCommand").setValue(Command.nextTrack.getName());
        settings.add("joystickInterval").setValue(String.valueOf(800));
        settings.add("joystickSpeed").setValue(String.valueOf(3));
        SettingsDocument doc = new SettingsDocument(settings);
        Iterator players = ExternalPlayer.getAll().iterator();
        while (players.hasNext()) {
            ExternalPlayer player = (ExternalPlayer)players.next();
            doc.addPlayer().setName(player.getName());
        }
        return doc;
    }

    public static SettingsDocument load(File file) {
        return new SettingsDocument(new XmlNode(file));
    }

    public SettingsDocument(XmlNode delegate) {
        this.setDelegate(delegate);
    }

    public void save(File file) {
        this.getDelegate().save(file);
    }

    public Player addPlayer() {
        return new Player().create(this);
    }

    public Players getPlayers() {
        Players result = new Players();
        XmlNodes.Iterator players = this.getDelegate().getAll("player").iterator();
        while (players.hasNext()) {
            XmlNode player = players.next();
            result.add(new Player(player));
        }
        return result;
    }

    public XmlNode getDelegate() {
        return this._delegate;
    }

    public void setDelegate(XmlNode delegate) {
        this._delegate = delegate;
    }

    public boolean getAutoCommandFocus() {
        return Boolean.valueOf(this.getDelegate().getValue("autoCommandFocus"));
    }

    public void setAutoCommandFocus(boolean autoCommandFocus) {
        this.getDelegate().get("autoCommandFocus").setValue(String.valueOf(autoCommandFocus));
    }

    public Element getAutoCommandFocusElement() {
        return this.getDelegate().get("autoCommandFocus").asElement();
    }

    public Command getJoystickLeftCommand() {
        return Command.valueOf(this.getDelegate().getValue("joystickLeftCommand"));
    }

    public void setJoystickLeftCommand(Command command) {
        this.getDelegate().get("joystickLeftCommand").setValue(command.getName());
    }

    public Command getJoystickRightCommand() {
        return Command.valueOf(this.getDelegate().getValue("joystickRightCommand"));
    }

    public void setJoystickRightCommand(Command command) {
        this.getDelegate().get("joystickRightCommand").setValue(command.getName());
    }

    public Command getJoystickUpCommand() {
        return Command.valueOf(this.getDelegate().getValue("joystickUpCommand"));
    }

    public void setJoystickUpCommand(Command command) {
        this.getDelegate().get("joystickUpCommand").setValue(command.getName());
    }

    public Command getJoystickDownCommand() {
        return Command.valueOf(this.getDelegate().getValue("joystickDownCommand"));
    }

    public void setJoystickDownCommand(Command command) {
        this.getDelegate().get("joystickDownCommand").setValue(command.getName());
    }

    public boolean getJoystickEnabled() {
        return Boolean.valueOf(this.getDelegate().getValue("joystickEnabled"));
    }

    public void setJoystickEnabled(boolean joystickEnabled) {
        this.getDelegate().get("joystickEnabled").setValue(String.valueOf(joystickEnabled));
    }

    public Element getJoystickEnabledElement() {
        return this.getDelegate().get("joystickEnabled").asElement();
    }

    public int getJoystickInterval() {
        return Integer.parseInt(this.getDelegate().getValue("joystickInterval"));
    }

    public void setJoystickInterval(int joystickInterval) {
        this.getDelegate().get("joystickInterval").setValue(String.valueOf(joystickInterval));
    }

    public Element getJoystickIntervalElement() {
        return this.getDelegate().get("joystickInterval").asElement();
    }

    public int getJoystickSpeed() {
        return Integer.parseInt(this.getDelegate().getValue("joystickSpeed"));
    }

    public void setJoystickSpeed(int joystickSpeed) {
        this.getDelegate().get("joystickSpeed").setValue(String.valueOf(joystickSpeed));
    }

    public Element getJoystickSpeedElement() {
        return this.getDelegate().get("joystickSpeed").asElement();
    }
}

