/*
 * Decompiled with CFR 0.152.
 */
package mpplayer.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import mpplayer.model.Player;
import mpplayer.model.PlayerActiveState;

public class Players {
    public static final Class VALUE_TYPE;
    public static final Players EMPTY_LIST;
    private List _delegate;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("mpplayer.model.Player");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        VALUE_TYPE = clazz;
        EMPTY_LIST = new Players(Collections.EMPTY_LIST);
    }

    public void setDelegate(List delegate) {
        this._delegate = delegate;
    }

    public List getDelegate() {
        return this._delegate;
    }

    public Players(List delegate) {
        this.setDelegate(delegate);
    }

    public Players(Player[] delegate) {
        this.setDelegate(Arrays.asList(delegate));
    }

    public Players() {
        this(new ArrayList());
    }

    public Players(Collection collection, boolean addAll) {
        this(new ArrayList(collection));
    }

    public Players(Players other) {
        this(other.getDelegate(), true);
    }

    public Players(int initialCapacity) {
        this(new ArrayList(initialCapacity));
    }

    public boolean equals(Object obj) {
        return obj instanceof Players && this.getDelegate().equals(((Players)obj).getDelegate());
    }

    public int hashCode() {
        return this.getDelegate().hashCode();
    }

    public String toString() {
        return this.getDelegate().toString();
    }

    public boolean add(Player player) {
        return this.getDelegate().add(player);
    }

    public boolean addAll(Players players) {
        return this.getDelegate().addAll(players.getDelegate());
    }

    public void clear() {
        this.getDelegate().clear();
    }

    public boolean contains(Player player) {
        return this.getDelegate().contains(player);
    }

    public boolean isEmpty() {
        return this.getDelegate().isEmpty();
    }

    public boolean remove(Player player) {
        return this.getDelegate().remove(player);
    }

    public boolean removeAll(Players players) {
        return this.getDelegate().removeAll(players.getDelegate());
    }

    public boolean retainAll(Players players) {
        return this.getDelegate().retainAll(players.getDelegate());
    }

    public int size() {
        return this.getDelegate().size();
    }

    public void add(int i, Player player) {
        this.getDelegate().add(i, player);
    }

    public boolean addAll(int i, Players players) {
        return this.getDelegate().addAll(i, players.getDelegate());
    }

    public boolean containsAll(Players players) {
        return this.getDelegate().containsAll(players.getDelegate());
    }

    public Player get(int i) {
        return (Player)this.getDelegate().get(i);
    }

    public int indexOf(Player player) {
        return this.getDelegate().indexOf(player);
    }

    public int lastIndexOf(Player player) {
        return this.getDelegate().lastIndexOf(player);
    }

    public Player set(int i, Player player) {
        return this.getDelegate().set(i, player);
    }

    public Players subList(int s, int e) {
        return new Players(this.getDelegate().subList(s, e));
    }

    public Player remove(int i) {
        return (Player)this.getDelegate().remove(i);
    }

    public Iterator iterator() {
        return new Iterator();
    }

    public Player[] toArray() {
        return this.getDelegate().toArray(new Player[this.size()]);
    }

    public Player getFirst() {
        return this.get(0);
    }

    public Player getSecond() {
        return this.get(1);
    }

    public Player getLast() {
        return this.get(this.size() - 1);
    }

    public Players select(Filter filter) {
        Players result = new Players(this.size());
        Iterator all = this.iterator();
        while (all.hasNext()) {
            Player item = all.next();
            if (!filter.matches(item)) continue;
            result.add(item);
        }
        return result;
    }

    public Players reject(Filter filter) {
        Players result = new Players(this.size());
        Iterator all = this.iterator();
        while (all.hasNext()) {
            Player item = all.next();
            if (filter.matches(item)) continue;
            result.add(item);
        }
        return result;
    }

    public Player selectFirst(Filter filter, Player defaultValue) {
        Player result = null;
        boolean found = false;
        Iterator all = this.iterator();
        while (all.hasNext() && !found) {
            Player item = all.next();
            if (!filter.matches(item)) continue;
            found = true;
            result = item;
        }
        if (!found) {
            result = defaultValue;
        }
        return result;
    }

    public Player selectFirst(Filter filter) {
        Player result = null;
        boolean found = false;
        Iterator all = this.iterator();
        while (all.hasNext() && !found) {
            Player item = all.next();
            if (!filter.matches(item)) continue;
            found = true;
            result = item;
        }
        if (!found) {
            throw new RuntimeException("No such element for filter: " + filter.getClass().getName());
        }
        return result;
    }

    public boolean exists(Filter filter) {
        boolean found = false;
        Iterator all = this.iterator();
        while (all.hasNext() && !found) {
            if (!filter.matches(all.next())) continue;
            found = true;
        }
        return found;
    }

    public void forEach(Method method) {
        Iterator all = this.iterator();
        while (all.hasNext()) {
            method.run(all.next());
        }
    }

    public void sort() {
        Collections.sort(this.getDelegate());
    }

    public void sort(Comparator comparator) {
        final Comparator c = comparator;
        Collections.sort(this.getDelegate(), new java.util.Comparator(){

            public int compare(Object o1, Object o2) {
                return c.compare((Player)o1, (Player)o2);
            }
        });
    }

    public Player getActivePlayer() {
        Player activePlayer = null;
        Iterator players = this.iterator();
        while (players.hasNext() && activePlayer == null) {
            Player player = players.next();
            if (!player.getPlayerActiveState().isEnabled()) continue;
            activePlayer = player;
        }
        return activePlayer;
    }

    public boolean hasActivePlayer() {
        return this.getActivePlayer() != null;
    }

    public void setActivePlayer(Player player) {
        PlayerActiveState.Disabled disabled = PlayerActiveState.disabled;
        Iterator players = this.iterator();
        while (players.hasNext()) {
            Player p = players.next();
            if (p.equals(player)) {
                p.setPlayerActiveState(PlayerActiveState.enabled);
                continue;
            }
            p.setPlayerActiveState(disabled);
        }
    }

    public class Iterator {
        private java.util.Iterator _iterator;
        private int _index;

        public Iterator() {
            this._iterator = Players.this.getDelegate().iterator();
            this._index = -1;
        }

        public int getIndex() {
            return this._index;
        }

        public Player next() {
            Player v_a_l_u_e = (Player)this.getIterator().next();
            ++this._index;
            return v_a_l_u_e;
        }

        public boolean hasNext() {
            return this.getIterator().hasNext();
        }

        public void remove() {
            this.getIterator().remove();
        }

        public java.util.Iterator getIterator() {
            return this._iterator;
        }
    }

    public interface Filter {
        public boolean matches(Player var1);
    }

    public interface Method {
        public void run(Player var1);
    }

    public static abstract class Comparator
    implements java.util.Comparator {
        public int compare(Object o1, Object o2) {
            return this.compare((Player)o1, (Player)o2);
        }

        public abstract int compare(Player var1, Player var2);
    }
}

