/*
 * Decompiled with CFR 0.152.
 */
package mpplayer.model;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class PlayerActiveState {
    public static final Enabled enabled = new Enabled();
    public static final Disabled disabled = new Disabled();
    public static final Undefined undefined = new Undefined();
    private static Map _name2ItemMap;
    private static List _all;
    public static final String NAME = "PlayerActiveState";

    protected PlayerActiveState() {
    }

    public String toString() {
        return this.getName();
    }

    public abstract String getName();

    public static PlayerActiveState valueOf(String name, PlayerActiveState defaultValue) {
        Map map = PlayerActiveState.getName2ItemMap();
        PlayerActiveState item = map.containsKey(name) ? (PlayerActiveState)map.get(name) : defaultValue;
        return item;
    }

    public static PlayerActiveState valueOf(String name) {
        PlayerActiveState i_t_e_m = PlayerActiveState.valueOf(name, null);
        if (i_t_e_m == null) {
            throw new IllegalArgumentException("name not in enumeration: " + name);
        }
        return i_t_e_m;
    }

    protected final Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    protected static Map getName2ItemMap() {
        if (_name2ItemMap == null) {
            HashMap<String, PlayerActiveState> map = new HashMap<String, PlayerActiveState>();
            Iterator all = PlayerActiveState.getAll().iterator();
            while (all.hasNext()) {
                PlayerActiveState item = (PlayerActiveState)all.next();
                map.put(item.getName(), item);
            }
            _name2ItemMap = map;
        }
        return _name2ItemMap;
    }

    public boolean isEnabled() {
        return this.equals(enabled);
    }

    public boolean isDisabled() {
        return this.equals(disabled);
    }

    public boolean isUndefined() {
        return this.equals(undefined);
    }

    public static List getAll() {
        if (_all == null) {
            _all = Arrays.asList(enabled, disabled, undefined);
        }
        return _all;
    }

    public static class Enabled
    extends PlayerActiveState {
        protected Enabled() {
        }

        public String getName() {
            return "enabled";
        }
    }

    public static class Disabled
    extends PlayerActiveState {
        protected Disabled() {
        }

        public String getName() {
            return "disabled";
        }
    }

    public static class Undefined
    extends PlayerActiveState {
        protected Undefined() {
        }

        public String getName() {
            return "undefined";
        }
    }
}

