/*
 * Decompiled with CFR 0.152.
 */
package mpplayer;

import com.o3tt3rli.eclipse.ui.frame.WizardPageMainFrame;
import com.o3tt3rli.eclipse.ui.model.BooleanNodeValue;
import com.o3tt3rli.eclipse.ui.model.IValue;
import com.o3tt3rli.eclipse.ui.model.IValueChangedListener;
import com.o3tt3rli.eclipse.ui.model.ModelButtonBinding;
import com.o3tt3rli.eclipse.ui.model.ModelTextBinding;
import com.o3tt3rli.eclipse.ui.model.ModelWizardPage;
import com.o3tt3rli.eclipse.ui.model.NumberNodeValue;
import com.o3tt3rli.eclipse.ui.model.Problem;
import com.o3tt3rli.eclipse.ui.model.ProblemSeverity;
import com.o3tt3rli.eclipse.ui.widgets.BorderPainter;
import com.o3tt3rli.eclipse.ui.widgets.ComboFrame;
import com.o3tt3rli.eclipse.ui.widgets.IControlVisitor;
import com.o3tt3rli.eclipse.ui.widgets.NumberTextFrame;
import com.o3tt3rli.eclipse.ui.widgets.TextFrame;
import com.o3tt3rli.eclipse.ui.widgets.XControl;
import com.o3tt3rli.util.Range;
import java.util.Iterator;
import java.util.List;
import mpplayer.Command;
import mpplayer.JoystickDirection;
import mpplayer.Main;
import mpplayer.MyJoystick;
import mpplayer.SettingsWizard;
import mpplayer.SettingsWizardPage;
import mpplayer.model.SettingsDocument;
import org.dom4j.Node;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class SettingsWizardPage
extends ModelWizardPage {
    private ComboFrame _leftFrame;
    private ComboFrame _rightFrame;
    private ComboFrame _upFrame;
    private ComboFrame _downFrame;
    private Button _joystickEnabledButton;
    private MyJoystick _joy;
    private TextFrame _testFrame;
    static /* synthetic */ Class class$0;

    public SettingsWizardPage() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("mpplayer.SettingsWizard");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        super(clazz.getName());
        this.setTitle("Settings");
        this.setDescription("Change Joystick Settings");
    }

    public void createControl(Composite container) {
        TextFrame testFrame;
        ComboFrame downFrame;
        ComboFrame rightFrame;
        ComboFrame leftFrame;
        ComboFrame upFrame;
        WizardPageMainFrame main = new WizardPageMainFrame(container, 0);
        main.setLayout((Layout)new GridLayout());
        Button button = new Button((Composite)main, 32);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SettingsWizardPage.this.onJoystickEnabledSelected();
            }
        });
        this._joystickEnabledButton = button;
        button.setText("&Enable Joystick");
        Composite directionContainer = new Composite((Composite)main, 0);
        GridLayout gl = new GridLayout();
        gl.numColumns = 3;
        directionContainer.setLayout((Layout)gl);
        class Filler {
            final /* synthetic */ SettingsWizardPage this$0;
            private final /* synthetic */ Composite val$directionContainer;

            Filler(SettingsWizardPage settingsWizardPage, Composite composite) {
                this.this$0 = settingsWizardPage;
                this.val$directionContainer = composite;
            }

            void fillWithComposite() {
                Composite c = new Composite(this.val$directionContainer, 0);
                GridData gd = new GridData();
                gd.heightHint = 0;
                gd.widthHint = 0;
                c.setLayoutData((Object)gd);
            }
        }
        Filler filler = new Filler(this, directionContainer);
        filler.fillWithComposite();
        int WH = 200;
        this._upFrame = upFrame = new ComboFrame(directionContainer, 0);
        GridData gdu = new GridData();
        gdu.widthHint = WH;
        upFrame.setLayoutData(gdu);
        upFrame.label.setText("&Up Command");
        filler.fillWithComposite();
        this._leftFrame = leftFrame = new ComboFrame(directionContainer, 0);
        GridData gdl = new GridData();
        gdl.widthHint = WH;
        leftFrame.setLayoutData(gdl);
        leftFrame.label.setText("&Left Command");
        filler.fillWithComposite();
        this._rightFrame = rightFrame = new ComboFrame(directionContainer, 0);
        GridData gdr = new GridData();
        gdr.widthHint = WH;
        rightFrame.setLayoutData(gdr);
        rightFrame.label.setText("&Right Command");
        filler.fillWithComposite();
        this._downFrame = downFrame = new ComboFrame(directionContainer, 0);
        GridData gdd = new GridData();
        gdd.widthHint = WH;
        downFrame.setLayoutData(gdd);
        downFrame.label.setText("&Down Command");
        filler.fillWithComposite();
        Composite xContainer = new Composite((Composite)main, 0);
        BorderPainter.addTo((Control)xContainer);
        xContainer.setLayoutData((Object)new GridData(768));
        GridLayout xgl = new GridLayout();
        xgl.numColumns = 2;
        xContainer.setLayout((Layout)xgl);
        Composite moreContainer = new Composite(xContainer, 0);
        moreContainer.setLayoutData((Object)new GridData());
        GridLayout glm = new GridLayout();
        glm.marginWidth = 0;
        glm.marginHeight = 0;
        moreContainer.setLayout((Layout)glm);
        Range intervalRange = new Range(100, 10000);
        Range speedRange = new Range(1, 10);
        NumberTextFrame intervalFrame = new NumberTextFrame(moreContainer, 0);
        intervalFrame.label.setText("&Timer Interval (" + intervalRange.getMin() + "-" + intervalRange.getMax() + " ms, default=" + 800 + ")");
        NumberTextFrame speedFrame = new NumberTextFrame(moreContainer, 0);
        speedFrame.label.setText("&Sensitivity (" + speedRange.getMin() + "-" + speedRange.getMax() + ", default=" + 3 + ")");
        this._testFrame = testFrame = new TextFrame(xContainer, 0);
        GridData gdt = new GridData(2);
        gdt.horizontalIndent = 30;
        testFrame.setLayoutData(gdt);
        testFrame.label.setText("Move your joystick to test your settings");
        MyJoystick joy = this.getJoy();
        joy.install(testFrame);
        joy.setEnabled(true);
        main.applyFrameStyle();
        SettingsDocument settings = this.getSettings();
        intervalFrame.getNumberText().setRange(intervalRange);
        speedFrame.getNumberText().setRange(speedRange);
        new ModelButtonBinding().bind((IValue)new BooleanNodeValue((Node)settings.getJoystickEnabledElement(), "joystickEnabled"), this._joystickEnabledButton);
        final ModelTextBinding intervalBinding = new ModelTextBinding();
        intervalBinding.addValueChangedListener(new IValueChangedListener(){

            public void changed() {
                if (intervalBinding.getProblems(true).isEmpty()) {
                    SettingsWizardPage.this.getJoy().setInterval(SettingsWizardPage.this.getSettings().getJoystickInterval());
                }
            }
        });
        intervalBinding.bind((IValue)new NumberNodeValue(intervalRange, (Node)settings.getJoystickIntervalElement(), "joystickInterval"), intervalFrame.text);
        final ModelTextBinding speedBinding = new ModelTextBinding();
        speedBinding.addValueChangedListener(new IValueChangedListener(){

            public void changed() {
                if (speedBinding.getProblems(true).isEmpty()) {
                    SettingsWizardPage.this.getJoy().setSpeed(SettingsWizardPage.this.getSettings().getJoystickSpeed());
                }
            }
        });
        speedBinding.bind((IValue)new NumberNodeValue(speedRange, (Node)settings.getJoystickSpeedElement(), "joystickSensitivity"), speedFrame.text);
        this.setControl((Control)main);
        Text testText = testFrame.text;
        testText.setEditable(false);
        testText.setEnabled(false);
        testText.setText("Joystick command will appear here");
        testText.setForeground(ColorConstants.gray);
        this.initSettingsWizardPage();
    }

    protected void onJoystickEnabledSelected() {
        final boolean enabled = this._joystickEnabledButton.getSelection();
        XControl.acceptChildren((Composite)this.getControl(), new IControlVisitor(){

            public boolean visit(Control control) {
                if (!control.equals(SettingsWizardPage.this._joystickEnabledButton)) {
                    control.setEnabled(enabled);
                }
                return true;
            }
        });
    }

    protected SettingsDocument getSettings() {
        return ((SettingsWizard)this.getWizard()).getSettings();
    }

    protected void initSettingsWizardPage() {
        ComboFrame[] comboFrames = new ComboFrame[]{this._rightFrame, this._leftFrame, this._upFrame, this._downFrame};
        final List dirs = JoystickDirection.getAll();
        Iterator all = Command.getAll().iterator();
        while (all.hasNext()) {
            Command cmd = (Command)all.next();
            if (cmd.isJumpToMarker()) continue;
            int i = 0;
            int n = comboFrames.length;
            while (i < n) {
                ComboFrame frame = comboFrames[i];
                Combo combo = frame.combo;
                combo.add(cmd.getInfo());
                combo.setVisibleItemCount(15);
                Integer index = new Integer(combo.getItemCount() - 1);
                combo.setData(String.valueOf(index), (Object)cmd);
                combo.setData(cmd.getName(), (Object)index);
                ++i;
            }
        }
        int i = 0;
        int n = comboFrames.length;
        while (i < n) {
            ComboFrame frame = comboFrames[i];
            final Combo combo = frame.combo;
            final int aI = i++;
            combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    JoystickDirection dir = (JoystickDirection)dirs.get(aI);
                    SettingsDocument settings = SettingsWizardPage.this.getSettings();
                    Command cmd = (Command)combo.getData(String.valueOf(combo.getSelectionIndex()));
                    if (dir.isRight()) {
                        settings.setJoystickRightCommand(cmd);
                    } else if (dir.isLeft()) {
                        settings.setJoystickLeftCommand(cmd);
                    } else if (dir.isUp()) {
                        settings.setJoystickUpCommand(cmd);
                    } else {
                        settings.setJoystickDownCommand(cmd);
                    }
                }
            });
        }
        class Selector {
            final /* synthetic */ SettingsWizardPage this$0;

            Selector(SettingsWizardPage settingsWizardPage) {
                this.this$0 = settingsWizardPage;
            }

            void select(Combo combo, Command cmd) {
                Object data = combo.getData(cmd.getName());
                if (data != null) {
                    combo.select(((Integer)data).intValue());
                }
            }
        }
        Selector selector = new Selector(this);
        SettingsDocument settings = this.getSettings();
        selector.select(this._rightFrame.combo, settings.getJoystickRightCommand());
        selector.select(this._leftFrame.combo, settings.getJoystickLeftCommand());
        selector.select(this._upFrame.combo, settings.getJoystickUpCommand());
        selector.select(this._downFrame.combo, settings.getJoystickDownCommand());
        Main main = Main.getInstance();
        final boolean hasJoy = main.getJoy().isAvailable();
        XControl.acceptChildren((Composite)this.getControl(), new IControlVisitor(){

            public boolean visit(Control control) {
                control.setEnabled(hasJoy);
                return true;
            }
        });
        this.onJoystickEnabledSelected();
    }

    public Problem getStatus() {
        Main main;
        MyJoystick joy;
        Problem status = super.getStatus();
        if (status.getSeverity().canContinue() && !(joy = (main = Main.getInstance()).getJoy()).isAvailable()) {
            String msg = "The Joystick support has been disabled due to the following reason:\n" + joy.getLastError();
            status = new Problem(ProblemSeverity.error, msg);
        }
        return status;
    }

    public MyJoystick getJoy() {
        if (this._joy == null) {
            SettingsDocument settings = this.getSettings();
            this._joy = new MyJoystick(settings.getJoystickInterval(), settings.getJoystickSpeed()){

                public void onJoystick(JoystickDirection direction) {
                    SettingsWizardPage.this.onJoystick(direction);
                }
            };
        }
        return this._joy;
    }

    protected void onJoystick(JoystickDirection dir) {
        Combo c = dir.isRight() ? this._rightFrame.combo : (dir.isLeft() ? this._leftFrame.combo : (dir.isUp() ? this._upFrame.combo : this._downFrame.combo));
        final Text text = this._testFrame.text;
        text.setText(c.getText());
        text.setForeground(ColorConstants.lightBlue);
        Thread thread = new Thread(){

            public void run() {
                try {
                    Thread.sleep(SettingsWizardPage.this.getJoy().getInterval() / 2);
                }
                catch (InterruptedException interruptedException) {}
                Display.getDefault().syncExec(new Runnable(this, text){
                    final /* synthetic */ 8 this$1;
                    private final /* synthetic */ Text val$text;
                    {
                        this.this$1 = var1_1;
                        this.val$text = text;
                    }

                    public void run() {
                        this.val$text.setText("");
                    }
                });
            }
        };
        thread.start();
    }
}

