/*
 * Decompiled with CFR 0.152.
 */
package mpplayer;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class PlayState {
    public static final Stopped stopped = new Stopped();
    public static final Paused paused = new Paused();
    public static final Playing playing = new Playing();
    public static final Undefined undefined = new Undefined();
    private static Map _name2ItemMap;
    private static List _all;

    protected PlayState() {
    }

    public String toString() {
        return this.getName();
    }

    public abstract String getName();

    public static PlayState valueOf(String name, PlayState defaultValue) {
        Map map = PlayState.getName2ItemMap();
        PlayState item = map.containsKey(name) ? (PlayState)map.get(name) : defaultValue;
        return item;
    }

    public static PlayState valueOf(String name) {
        PlayState i_t_e_m = PlayState.valueOf(name, null);
        if (i_t_e_m == null) {
            throw new IllegalArgumentException("name not in enumeration: " + name);
        }
        return i_t_e_m;
    }

    protected final Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    protected static Map getName2ItemMap() {
        if (_name2ItemMap == null) {
            HashMap<String, PlayState> map = new HashMap<String, PlayState>();
            Iterator all = PlayState.getAll().iterator();
            while (all.hasNext()) {
                PlayState item = (PlayState)all.next();
                map.put(item.getName(), item);
            }
            _name2ItemMap = map;
        }
        return _name2ItemMap;
    }

    public boolean isStopped() {
        return this.equals(stopped);
    }

    public boolean isPaused() {
        return this.equals(paused);
    }

    public boolean isPlaying() {
        return this.equals(playing);
    }

    public boolean isUndefined() {
        return this.equals(undefined);
    }

    public static List getAll() {
        if (_all == null) {
            _all = Arrays.asList(stopped, paused, playing, undefined);
        }
        return _all;
    }

    public static class Stopped
    extends PlayState {
        protected Stopped() {
        }

        public String getName() {
            return "stopped";
        }
    }

    public static class Paused
    extends PlayState {
        protected Paused() {
        }

        public String getName() {
            return "paused";
        }
    }

    public static class Playing
    extends PlayState {
        protected Playing() {
        }

        public String getName() {
            return "playing";
        }
    }

    public static class Undefined
    extends PlayState {
        protected Undefined() {
        }

        public String getName() {
            return "undefined";
        }
    }
}

