/*
 * Decompiled with CFR 0.152.
 */
package mpplayer;

import com.o3tt3rli.lang.XString;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import mpplayer.MpplayerException;
import mpplayer.ToolUpdateCommandUI;
import mpplayer.UpdateCmdUi;
import mpplayer.resource.Resource;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.ToolItem;

public abstract class Command {
    public static final JumpToMarker jumpToMarker = new JumpToMarker();
    public static final AddMarker addMarker = new AddMarker();
    public static final RemoveMarker removeMarker = new RemoveMarker();
    public static final RemoveAllMarkers removeAllMarkers = new RemoveAllMarkers();
    public static final Play play = new Play();
    public static final Stop stop = new Stop();
    public static final Back back = new Back();
    public static final Forward forward = new Forward();
    public static final Home home = new Home();
    public static final PreviousTrack previousTrack = new PreviousTrack();
    public static final NextTrack nextTrack = new NextTrack();
    public static final BackToLastMarker backToLastMarker = new BackToLastMarker();
    public static final PreviousMarker previousMarker = new PreviousMarker();
    public static final NextMarker nextMarker = new NextMarker();
    public static final PlayListOpen playListOpen = new PlayListOpen();
    public static final PlayListSaveAs playListSaveAs = new PlayListSaveAs();
    public static final PlayListAddTracks playListAddTracks = new PlayListAddTracks();
    public static final PlayListRemoveTracks playListRemoveTracks = new PlayListRemoveTracks();
    public static final PlayListRemoveAllTracks playListRemoveAllTracks = new PlayListRemoveAllTracks();
    public static final Quit quit = new Quit();
    public static final ChoosePlayer choosePlayer = new ChoosePlayer();
    public static final AutoCommandFocus autoCommandFocus = new AutoCommandFocus();
    public static final JoystickSettings joystickSettings = new JoystickSettings();
    public static final About about = new About();
    private static Map _name2ItemMap;
    private static List _all;
    private ToolItem _tool;
    private static Object _listener;
    private Character _key;
    private String _info;
    private Image _image;
    private Image _image2;
    static /* synthetic */ Class class$0;

    protected Command() {
    }

    public String toString() {
        return this.getName();
    }

    public abstract String getName();

    public static Command valueOf(String name, Command defaultValue) {
        Map map = Command.getName2ItemMap();
        Command item = map.containsKey(name) ? (Command)map.get(name) : defaultValue;
        return item;
    }

    public static Command valueOf(String name) {
        Command i_t_e_m = Command.valueOf(name, null);
        if (i_t_e_m == null) {
            throw new IllegalArgumentException("name not in enumeration: " + name);
        }
        return i_t_e_m;
    }

    protected final Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    protected static Map getName2ItemMap() {
        if (_name2ItemMap == null) {
            HashMap<String, Command> map = new HashMap<String, Command>();
            Iterator all = Command.getAll().iterator();
            while (all.hasNext()) {
                Command item = (Command)all.next();
                map.put(item.getName(), item);
            }
            _name2ItemMap = map;
        }
        return _name2ItemMap;
    }

    public boolean isJumpToMarker() {
        return this.equals(jumpToMarker);
    }

    public boolean isAddMarker() {
        return this.equals(addMarker);
    }

    public boolean isRemoveMarker() {
        return this.equals(removeMarker);
    }

    public boolean isRemoveAllMarkers() {
        return this.equals(removeAllMarkers);
    }

    public boolean isPlay() {
        return this.equals(play);
    }

    public boolean isStop() {
        return this.equals(stop);
    }

    public boolean isBack() {
        return this.equals(back);
    }

    public boolean isForward() {
        return this.equals(forward);
    }

    public boolean isHome() {
        return this.equals(home);
    }

    public boolean isPreviousTrack() {
        return this.equals(previousTrack);
    }

    public boolean isNextTrack() {
        return this.equals(nextTrack);
    }

    public boolean isBackToLastMarker() {
        return this.equals(backToLastMarker);
    }

    public boolean isPreviousMarker() {
        return this.equals(previousMarker);
    }

    public boolean isNextMarker() {
        return this.equals(nextMarker);
    }

    public boolean isPlayListOpen() {
        return this.equals(playListOpen);
    }

    public boolean isPlayListSaveAs() {
        return this.equals(playListSaveAs);
    }

    public boolean isPlayListAddTracks() {
        return this.equals(playListAddTracks);
    }

    public boolean isPlayListRemoveTracks() {
        return this.equals(playListRemoveTracks);
    }

    public boolean isPlayListRemoveAllTracks() {
        return this.equals(playListRemoveAllTracks);
    }

    public boolean isQuit() {
        return this.equals(quit);
    }

    public boolean isChoosePlayer() {
        return this.equals(choosePlayer);
    }

    public boolean isAutoCommandFocus() {
        return this.equals(autoCommandFocus);
    }

    public boolean isJoystickSettings() {
        return this.equals(joystickSettings);
    }

    public boolean isAbout() {
        return this.equals(about);
    }

    public static List getAll() {
        if (_all == null) {
            _all = Arrays.asList(jumpToMarker, addMarker, removeMarker, removeAllMarkers, play, stop, back, forward, home, previousTrack, nextTrack, backToLastMarker, previousMarker, nextMarker, playListOpen, playListSaveAs, playListAddTracks, playListRemoveTracks, playListRemoveAllTracks, quit, choosePlayer, autoCommandFocus, joystickSettings, about);
        }
        return _all;
    }

    public ToolItem getTool() {
        return this._tool;
    }

    public void setTool(ToolItem tool) {
        tool.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Command.this.invoke(e.detail == 4);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        tool.setImage(this.getImage());
        this._tool = tool;
    }

    public String getHandlerName() {
        return "onTool" + XString.capitalize((String)this.getName());
    }

    public String getDropDownHandlerName() {
        return "onToolDropDown" + XString.capitalize((String)this.getName());
    }

    public String getUpdateUIHandlerName() {
        return "onUpdateToolUI" + XString.capitalize((String)this.getName());
    }

    public UpdateCmdUi updateToolUI() {
        ToolUpdateCommandUI result = null;
        if (this.hasTool()) {
            try {
                ToolUpdateCommandUI cmdUI = new ToolUpdateCommandUI(this.getTool());
                Object l = Command.getListener();
                Method handler = null;
                try {
                    Class<?> clazz = l.getClass();
                    String string = this.getUpdateUIHandlerName();
                    Class[] classArray = new Class[1];
                    Class<?> clazz2 = class$0;
                    if (clazz2 == null) {
                        try {
                            clazz2 = class$0 = Class.forName("mpplayer.UpdateCmdUi");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    classArray[0] = clazz2;
                    handler = clazz.getMethod(string, classArray);
                }
                catch (Exception exception) {}
                if (handler != null) {
                    try {
                        handler.invoke(l, (Object[])new UpdateCmdUi[]{cmdUI});
                        result = cmdUI;
                    }
                    catch (Exception exception) {}
                }
            }
            catch (Exception e) {
                throw new MpplayerException(e);
            }
        }
        return result;
    }

    public static void updateAllToolsUI() {
        Iterator all = Command.getAll().iterator();
        while (all.hasNext()) {
            ((Command)all.next()).updateToolUI();
        }
    }

    public void invoke(boolean dropDown) {
        block7: {
            if (Command.hasListener()) {
                try {
                    boolean doIt = true;
                    UpdateCmdUi cmdUI = this.updateToolUI();
                    if (cmdUI != null) {
                        doIt = cmdUI.getEnabled();
                    }
                    if (!doIt) break block7;
                    Object l = Command.getListener();
                    Method handler = null;
                    try {
                        handler = l.getClass().getMethod(dropDown ? this.getDropDownHandlerName() : this.getHandlerName(), null);
                    }
                    catch (Exception exception) {}
                    if (handler != null) {
                        handler.invoke(l, null);
                    }
                }
                catch (Exception e) {
                    throw new MpplayerException(e);
                }
            }
        }
    }

    public static Object getListener() {
        return _listener;
    }

    public static boolean hasListener() {
        return Command.getListener() != null;
    }

    public static void setListener(Object listener) {
        _listener = listener;
    }

    public static void unsetListener() {
        Command.setListener(null);
    }

    public String getInfo() {
        return this._info;
    }

    public char getKey() {
        if (this._key == null) {
            System.err.println("warning. key has not been set");
            this._key = new Character('\u0000');
        }
        return this._key.charValue();
    }

    public void setInfo(String info) {
        this._info = info;
        if (this.hasTool()) {
            this.getTool().setToolTipText(String.valueOf(info) + " (" + this.getKey() + ")");
        }
    }

    public boolean hasTool() {
        return this.getTool() != null;
    }

    public void setKey(char key) {
        this._key = new Character(key);
    }

    public void setKeyInfo(char key, String info) {
        this.setKey(key);
        this.setInfo(info);
    }

    public Image getImage() {
        Resource res;
        if (this._image == null && (res = Resource.valueOf(this.getName(), null)) != null) {
            this._image = res.createImage();
        }
        return this._image;
    }

    public Image getImage2() {
        if (this._image2 == null && this.isPlay()) {
            this._image2 = Resource.pause.createImage();
        }
        return this._image2;
    }

    public boolean hasKey() {
        return this.getKey() > '\u0000';
    }

    public static class JumpToMarker
    extends Command {
        protected JumpToMarker() {
        }

        public String getName() {
            return "jumpToMarker";
        }
    }

    public static class AddMarker
    extends Command {
        protected AddMarker() {
        }

        public String getName() {
            return "addMarker";
        }
    }

    public static class RemoveMarker
    extends Command {
        protected RemoveMarker() {
        }

        public String getName() {
            return "removeMarker";
        }
    }

    public static class RemoveAllMarkers
    extends Command {
        protected RemoveAllMarkers() {
        }

        public String getName() {
            return "removeAllMarkers";
        }
    }

    public static class Play
    extends Command {
        protected Play() {
        }

        public String getName() {
            return "play";
        }
    }

    public static class Stop
    extends Command {
        protected Stop() {
        }

        public String getName() {
            return "stop";
        }
    }

    public static class Back
    extends Command {
        protected Back() {
        }

        public String getName() {
            return "back";
        }
    }

    public static class Forward
    extends Command {
        protected Forward() {
        }

        public String getName() {
            return "forward";
        }
    }

    public static class Home
    extends Command {
        protected Home() {
        }

        public String getName() {
            return "home";
        }
    }

    public static class PreviousTrack
    extends Command {
        protected PreviousTrack() {
        }

        public String getName() {
            return "previousTrack";
        }
    }

    public static class NextTrack
    extends Command {
        protected NextTrack() {
        }

        public String getName() {
            return "nextTrack";
        }
    }

    public static class BackToLastMarker
    extends Command {
        protected BackToLastMarker() {
        }

        public String getName() {
            return "backToLastMarker";
        }
    }

    public static class PreviousMarker
    extends Command {
        protected PreviousMarker() {
        }

        public String getName() {
            return "previousMarker";
        }
    }

    public static class NextMarker
    extends Command {
        protected NextMarker() {
        }

        public String getName() {
            return "nextMarker";
        }
    }

    public static class PlayListOpen
    extends Command {
        protected PlayListOpen() {
        }

        public String getName() {
            return "playListOpen";
        }
    }

    public static class PlayListSaveAs
    extends Command {
        protected PlayListSaveAs() {
        }

        public String getName() {
            return "playListSaveAs";
        }
    }

    public static class PlayListAddTracks
    extends Command {
        protected PlayListAddTracks() {
        }

        public String getName() {
            return "playListAddTracks";
        }
    }

    public static class PlayListRemoveTracks
    extends Command {
        protected PlayListRemoveTracks() {
        }

        public String getName() {
            return "playListRemoveTracks";
        }
    }

    public static class PlayListRemoveAllTracks
    extends Command {
        protected PlayListRemoveAllTracks() {
        }

        public String getName() {
            return "playListRemoveAllTracks";
        }
    }

    public static class Quit
    extends Command {
        protected Quit() {
        }

        public String getName() {
            return "quit";
        }
    }

    public static class ChoosePlayer
    extends Command {
        protected ChoosePlayer() {
        }

        public String getName() {
            return "choosePlayer";
        }
    }

    public static class AutoCommandFocus
    extends Command {
        protected AutoCommandFocus() {
        }

        public String getName() {
            return "autoCommandFocus";
        }
    }

    public static class JoystickSettings
    extends Command {
        protected JoystickSettings() {
        }

        public String getName() {
            return "joystickSettings";
        }
    }

    public static class About
    extends Command {
        protected About() {
        }

        public String getName() {
            return "about";
        }
    }
}

