/*
 * Decompiled with CFR 0.152.
 */
package com.o3tt3rli.eclipse.ui.widgets;

import com.o3tt3rli.lang.XString;
import com.o3tt3rli.util.Range;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class NumberText
extends Text {
    private Range _range;

    protected void checkSubclass() {
    }

    public NumberText(Composite parent, int style) {
        this(parent, style, null);
    }

    public NumberText(Composite parent, int style, Range range) {
        super(parent, style);
        this.setRange(range);
        this.addListener(25, new Listener(){

            public void handleEvent(Event event) {
                char c = event.character;
                if (event.keyCode == 0 && c != '\u0000') {
                    boolean allowNegative = NumberText.this.getRange().getMin() < 0;
                    event.doit = Character.isDigit(c) || allowNegative && c == '-' && NumberText.this.getCaretPosition() == 0;
                }
            }
        });
        this.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                int dx = 0;
                if (e.keyCode == 0x1000001) {
                    dx = 1;
                } else if (e.keyCode == 0x1000002) {
                    dx = -1;
                }
                if (dx != 0 && NumberText.this.getEditable()) {
                    NumberText.this.increase(dx);
                    NumberText.this.selectAll();
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
    }

    public void increase(int dx) {
        int n;
        String text = this.getText();
        if (!XString.isSet((String)text)) {
            n = 0;
        } else {
            try {
                n = Integer.parseInt(text);
            }
            catch (Exception exception) {
                n = 0;
            }
            n += dx;
        }
        this.setText(String.valueOf(n));
    }

    public void setText(String text) {
        int n;
        Range range = this.getRange();
        int min = range.getMin();
        int max = range.getMax();
        try {
            n = Range.parse((String)text);
        }
        catch (Exception exception) {
            n = 0;
        }
        if (n < min) {
            n = min;
        } else if (n > max) {
            n = max;
        }
        String newText = Range.isUnboundedMax((String)text) && max == Range.UNBOUNDED_MAX ? text : String.valueOf(n);
        super.setText(newText);
    }

    public Range getRange() {
        if (this._range == null) {
            this._range = Range.UNBOUNDED;
        }
        return this._range;
    }

    public void setRange(Range range) {
        this._range = range;
    }

    public int getValue() {
        return Integer.parseInt(this.getText());
    }

    public void setValue(int value) {
        this.setText(String.valueOf(value));
    }
}

