/*
 * Decompiled with CFR 0.152.
 */
package com.o3tt3rli.eclipse.ui.widgets;

import com.o3tt3rli.lang.XString;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public class ControlPrompter
implements PaintListener {
    private String _prompt;

    public static ControlPrompter addTo(Control control, String prompt) {
        ControlPrompter prompter = new ControlPrompter(prompt);
        control.addPaintListener((PaintListener)prompter);
        control.addFocusListener(new FocusListener(){

            protected void onFocus(Control c) {
                c.redraw();
            }

            public void focusGained(FocusEvent e) {
                this.onFocus((Control)e.widget);
            }

            public void focusLost(FocusEvent e) {
                this.onFocus((Control)e.widget);
            }
        });
        return prompter;
    }

    public ControlPrompter() {
    }

    public ControlPrompter(String prompt) {
        this.setPrompt(prompt);
    }

    public void paintControl(PaintEvent e) {
        Control control = (Control)e.widget;
        if (this.hasPrompt() && !control.isFocusControl()) {
            String text = null;
            Rectangle bounds = null;
            if (control instanceof Text) {
                Text aText = (Text)control;
                text = aText.getText();
                bounds = aText.getClientArea();
            } else if (control instanceof Combo) {
                Combo combo = (Combo)control;
                text = combo.getText();
                bounds = combo.getClientArea();
            }
            if (text != null && text.length() == 0) {
                GC gc = e.gc;
                gc.setForeground(control.getDisplay().getSystemColor(15));
                gc.drawText(this.getPrompt(), bounds.x + 2, bounds.y, true);
            }
        }
    }

    public String getPrompt() {
        return this._prompt;
    }

    public boolean hasPrompt() {
        return XString.isSet((String)this.getPrompt());
    }

    public void setPrompt(String prompt) {
        this._prompt = prompt;
    }
}

