/*
 * Decompiled with CFR 0.152.
 */
package com.o3tt3rli.util;

import com.o3tt3rli.lang.XString;

public class Range {
    public static int UNBOUNDED_MIN = Integer.MIN_VALUE;
    public static int UNBOUNDED_MAX = Integer.MAX_VALUE;
    private int _min;
    private int _max;
    private boolean _minIncl;
    private boolean _maxIncl;
    public static final Range UNBOUNDED = new Range(UNBOUNDED_MIN, UNBOUNDED_MAX);

    public Range(int min, boolean minIncl, int max, boolean maxIncl) {
        this.setMin(min);
        this.setMinIncl(minIncl);
        this.setMax(max);
        this.setMaxIncl(maxIncl);
    }

    public Range(int min, int max) {
        this(min, true, max, true);
    }

    public boolean isValid(int number) {
        return number >= this.getMin() && number <= this.getMax();
    }

    public int getMax() {
        int max = this._max;
        if (!this.getMaxIncl()) {
            --max;
        }
        return max;
    }

    public int getMin() {
        int min = this._min;
        if (!this.getMinIncl()) {
            ++min;
        }
        return min;
    }

    public boolean getMinIncl() {
        return this._minIncl;
    }

    protected void setMax(int max) {
        this._max = max;
    }

    protected void setMin(int min) {
        this._min = min;
    }

    protected void setMinIncl(boolean minIncl) {
        this._minIncl = minIncl;
    }

    public boolean getMaxIncl() {
        return this._maxIncl;
    }

    protected void setMaxIncl(boolean maxIncl) {
        this._maxIncl = maxIncl;
    }

    public static int parse(String s) {
        int n = Range.isUnboundedMax(s) ? UNBOUNDED_MAX : (Range.isUnboundedMin(s) ? UNBOUNDED_MIN : Integer.parseInt(s));
        return n;
    }

    public static boolean isUnboundedMin(String s) {
        return "-".equals(s);
    }

    public static boolean isUnboundedMin(int value) {
        return value == UNBOUNDED_MIN;
    }

    public static boolean isUnboundedMax(String s) {
        return !XString.isSet(s);
    }

    public static boolean isUnboundedMax(int value) {
        return value == UNBOUNDED_MAX;
    }
}

