/*
 * Decompiled with CFR 0.152.
 */
package com.o3tt3rli.util;

import com.o3tt3rli.io.FileSet;
import com.o3tt3rli.lang.XString;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ClassPath {
    public static final Class VALUE_TYPE;
    public static final ClassPath EMPTY_LIST;
    private List _delegate;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        VALUE_TYPE = clazz;
        EMPTY_LIST = new ClassPath(Collections.EMPTY_LIST);
    }

    public void setDelegate(List delegate) {
        this._delegate = delegate;
    }

    public List getDelegate() {
        return this._delegate;
    }

    public ClassPath(List delegate) {
        this.setDelegate(delegate);
    }

    public ClassPath(String[] delegate) {
        this.setDelegate(Arrays.asList(delegate));
    }

    public ClassPath() {
        this(new ArrayList());
    }

    public ClassPath(Collection collection, boolean addAll) {
        this(new ArrayList(collection));
    }

    public ClassPath(ClassPath other) {
        this(other.getDelegate(), true);
    }

    public ClassPath(int initialCapacity) {
        this(new ArrayList(initialCapacity));
    }

    public boolean equals(Object obj) {
        return obj instanceof ClassPath && this.getDelegate().equals(((ClassPath)obj).getDelegate());
    }

    public int hashCode() {
        return this.getDelegate().hashCode();
    }

    public String toString() {
        return this.getDelegate().toString();
    }

    public boolean add(String string) {
        return this.getDelegate().add(string);
    }

    public boolean addAll(ClassPath classPath) {
        return this.getDelegate().addAll(classPath.getDelegate());
    }

    public void clear() {
        this.getDelegate().clear();
    }

    public boolean contains(String string) {
        return this.getDelegate().contains(string);
    }

    public boolean isEmpty() {
        return this.getDelegate().isEmpty();
    }

    public boolean remove(String string) {
        return this.getDelegate().remove(string);
    }

    public boolean removeAll(ClassPath classPath) {
        return this.getDelegate().removeAll(classPath.getDelegate());
    }

    public boolean retainAll(ClassPath classPath) {
        return this.getDelegate().retainAll(classPath.getDelegate());
    }

    public int size() {
        return this.getDelegate().size();
    }

    public void add(int i, String string) {
        this.getDelegate().add(i, string);
    }

    public boolean addAll(int i, ClassPath classPath) {
        return this.getDelegate().addAll(i, classPath.getDelegate());
    }

    public boolean containsAll(ClassPath classPath) {
        return this.getDelegate().containsAll(classPath.getDelegate());
    }

    public String get(int i) {
        return (String)this.getDelegate().get(i);
    }

    public int indexOf(String string) {
        return this.getDelegate().indexOf(string);
    }

    public int lastIndexOf(String string) {
        return this.getDelegate().lastIndexOf(string);
    }

    public String set(int i, String string) {
        return this.getDelegate().set(i, string);
    }

    public ClassPath subList(int s, int e) {
        return new ClassPath(this.getDelegate().subList(s, e));
    }

    public String remove(int i) {
        return (String)this.getDelegate().remove(i);
    }

    public Iterator iterator() {
        return new Iterator();
    }

    public String[] toArray() {
        return this.getDelegate().toArray(new String[this.size()]);
    }

    public String getFirst() {
        return this.get(0);
    }

    public String getSecond() {
        return this.get(1);
    }

    public String getLast() {
        return this.get(this.size() - 1);
    }

    public ClassPath select(Filter filter) {
        ClassPath result = new ClassPath(this.size());
        Iterator all = this.iterator();
        while (all.hasNext()) {
            String item = all.next();
            if (!filter.matches(item)) continue;
            result.add(item);
        }
        return result;
    }

    public ClassPath reject(Filter filter) {
        ClassPath result = new ClassPath(this.size());
        Iterator all = this.iterator();
        while (all.hasNext()) {
            String item = all.next();
            if (filter.matches(item)) continue;
            result.add(item);
        }
        return result;
    }

    public String selectFirst(Filter filter, String defaultValue) {
        String result = null;
        boolean found = false;
        Iterator all = this.iterator();
        while (all.hasNext() && !found) {
            String item = all.next();
            if (!filter.matches(item)) continue;
            found = true;
            result = item;
        }
        if (!found) {
            result = defaultValue;
        }
        return result;
    }

    public String selectFirst(Filter filter) {
        String result = null;
        boolean found = false;
        Iterator all = this.iterator();
        while (all.hasNext() && !found) {
            String item = all.next();
            if (!filter.matches(item)) continue;
            found = true;
            result = item;
        }
        if (!found) {
            throw new RuntimeException("No such element for filter: " + filter.getClass().getName());
        }
        return result;
    }

    public boolean exists(Filter filter) {
        boolean found = false;
        Iterator all = this.iterator();
        while (all.hasNext() && !found) {
            if (!filter.matches(all.next())) continue;
            found = true;
        }
        return found;
    }

    public void forEach(Method method) {
        Iterator all = this.iterator();
        while (all.hasNext()) {
            method.run(all.next());
        }
    }

    public void sort() {
        Collections.sort(this.getDelegate());
    }

    public void sort(Comparator comparator) {
        final Comparator c = comparator;
        Collections.sort(this.getDelegate(), new java.util.Comparator(){

            public int compare(Object o1, Object o2) {
                return c.compare((String)o1, (String)o2);
            }
        });
    }

    public String toExternalForm() {
        StringBuffer result = new StringBuffer();
        Iterator entries = this.iterator();
        while (entries.hasNext()) {
            if (result.length() > 0) {
                result.append(';');
            }
            result.append(entries.next());
        }
        return result.toString();
    }

    public ClassPath(String cp) {
        this();
        StringTokenizer cps = new StringTokenizer(cp, ";");
        while (cps.hasMoreTokens()) {
            this.add(cps.nextToken());
        }
    }

    public FileSet getClasses(String prefix) {
        try {
            FileSet result = new FileSet();
            boolean doAlwaysAdd = !XString.isSet(prefix);
            String aPackage = prefix.replace('.', '/');
            Iterator all = this.iterator();
            while (all.hasNext()) {
                String aPath = all.next();
                File path = new File(aPath);
                if (doAlwaysAdd) {
                    result.add(path);
                    continue;
                }
                if (path.isDirectory()) {
                    File packageDir = new File(path, aPackage);
                    if (!packageDir.exists()) continue;
                    result.add(packageDir);
                    continue;
                }
                try {
                    ZipFile file = new ZipFile(path, 1);
                    Enumeration<? extends ZipEntry> entries = file.entries();
                    boolean added = false;
                    while (entries.hasMoreElements() && !added) {
                        ZipEntry entry = entries.nextElement();
                        String entryName = entry.getName();
                        if (!entryName.startsWith(aPackage)) continue;
                        added = true;
                        result.add(path);
                    }
                }
                catch (Exception exception) {}
            }
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public class Iterator {
        private java.util.Iterator _iterator;
        private int _index;

        public Iterator() {
            this._iterator = ClassPath.this.getDelegate().iterator();
            this._index = -1;
        }

        public int getIndex() {
            return this._index;
        }

        public String next() {
            String v_a_l_u_e = (String)this.getIterator().next();
            ++this._index;
            return v_a_l_u_e;
        }

        public boolean hasNext() {
            return this.getIterator().hasNext();
        }

        public void remove() {
            this.getIterator().remove();
        }

        public java.util.Iterator getIterator() {
            return this._iterator;
        }
    }

    public interface Filter {
        public boolean matches(String var1);
    }

    public interface Method {
        public void run(String var1);
    }

    public static abstract class Comparator
    implements java.util.Comparator {
        public int compare(Object o1, Object o2) {
            return this.compare((String)o1, (String)o2);
        }

        public abstract int compare(String var1, String var2);
    }
}

