/*
 * Decompiled with CFR 0.152.
 */
package com.o3tt3rli.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;

public class ChildProcess {
    public static final int INFINITE_TIMEOUT = -1;
    public static final int DESTROYED_AFTER_TIMEOUT = -9898;
    private static final int NOT_SET_EXITVALUE = -1;
    private String _command = null;
    private String[] _commandArray = null;
    private int _timeout = -1;
    private long _pollAliveInterval = 1000L;
    private Process _process;
    private int _exitValue = -1;
    private long _startTime;
    private boolean _debug = false;

    public ChildProcess() {
    }

    public ChildProcess(String command) {
        this.setCommand(command);
    }

    public ChildProcess(String[] commandArray) {
        this.setCommandArray(commandArray);
    }

    public ChildProcess(String command, int timeout) {
        this.setCommand(command);
        this.setTimeout(timeout);
    }

    public ChildProcess(String[] commandArray, int timeout) {
        this.setCommandArray(commandArray);
        this.setTimeout(timeout);
    }

    public void setCommand(String command) {
        this._command = command;
    }

    public String getCommand() {
        return this._command;
    }

    public void setCommandArray(String[] commandArray) {
        this._commandArray = commandArray;
    }

    public String[] getCommandArray() {
        return this._commandArray;
    }

    public void setTimeout(int timeout) {
        this._timeout = timeout;
    }

    public int getTimeout() {
        return this._timeout;
    }

    public void setDebug(boolean debug) {
        this._debug = debug;
    }

    public boolean isDebug() {
        return this._debug;
    }

    public void setPollAliveInterval(long pollAliveInterval) {
        this._pollAliveInterval = pollAliveInterval;
    }

    public long getPollAliveInterval() {
        return this._pollAliveInterval;
    }

    private boolean timeout() {
        boolean isTimeout = false;
        long currentTime = System.currentTimeMillis();
        long diff = 0L;
        long threshold = 1000 * this.getTimeout();
        if (this.getTimeout() != -1 && (diff = currentTime - this._startTime) > threshold) {
            isTimeout = true;
        }
        return isTimeout;
    }

    public int run() {
        try {
            this._startTime = System.currentTimeMillis();
            this._process = this.getCommandArray() != null ? Runtime.getRuntime().exec(this.getCommandArray()) : Runtime.getRuntime().exec(this.getCommand());
            this.debugCommand();
            StdoutMonitor stdoutMonitor = new StdoutMonitor();
            stdoutMonitor.start();
            StderrMonitor stderrMonitor = new StderrMonitor();
            stderrMonitor.start();
            while (!this.timeout() && this.isAlive()) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ie) {
                    ie.printStackTrace();
                }
            }
            if (this.isAlive()) {
                this.destroy();
            }
            return this.getExitValue();
        }
        catch (Exception ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public int getExitValue() {
        return this._exitValue;
    }

    private void setExitValue(int exitValue) {
        this._exitValue = exitValue;
    }

    private boolean isAlive() {
        try {
            this.setExitValue(this._process.exitValue());
            return false;
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
            return true;
        }
    }

    private void destroy() {
        this._process.destroy();
        this.setExitValue(-9898);
        if (this.isDebug()) {
            System.out.println("[ChildProcess] destroying because of timeout !");
        }
    }

    private void debugCommand() {
        if (this.isDebug()) {
            if (this.getCommandArray() != null) {
                System.out.print("[ChildProcess] command '");
                int i = 0;
                while (i < this.getCommandArray().length) {
                    if (i == 0) {
                        System.out.print(this.getCommandArray()[i]);
                    } else {
                        System.out.print(" " + this.getCommandArray()[i]);
                    }
                    ++i;
                }
                System.out.println("' is now running...");
            } else {
                System.out.println("[ChildProcess] command '" + this.getCommand() + "' is now running...");
            }
        }
    }

    private class StdoutMonitor
    extends Thread {
        StdoutMonitor() {
        }

        public void run() {
            String line = null;
            BufferedReader stdout = new BufferedReader(new InputStreamReader(ChildProcess.this._process.getInputStream()));
            try {
                while ((line = stdout.readLine()) != null) {
                    System.out.println(line);
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    }

    private class StderrMonitor
    extends Thread {
        StderrMonitor() {
        }

        public void run() {
            String line = null;
            BufferedReader stderr = new BufferedReader(new InputStreamReader(ChildProcess.this._process.getErrorStream()));
            try {
                while ((line = stderr.readLine()) != null) {
                    System.err.println(line);
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    }
}

